/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import com.google.common.collect.ForwardingSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TravelerSet
extends ForwardingSet<TravelingItem> {
    public boolean iterating;
    private final Set<TravelingItem> items = new HashSet<TravelingItem>();
    private final Set<TravelingItem> toLoad = new HashSet<TravelingItem>();
    private final Set<TravelingItem> toAdd = new HashSet<TravelingItem>();
    private final Set<TravelingItem> toRemove = new HashSet<TravelingItem>();
    private int delay = 0;
    private final PipeTransportItems transport;

    public TravelerSet(PipeTransportItems transport) {
        this.transport = transport;
    }

    protected Set<TravelingItem> delegate() {
        return this.items;
    }

    public boolean add(TravelingItem item) {
        if (this.iterating) {
            return this.toAdd.add(item);
        }
        item.setContainer(this.transport.container);
        this.items.add(item);
        return true;
    }

    public boolean addAll(Collection<? extends TravelingItem> collection) {
        if (this.iterating) {
            return this.toAdd.addAll(collection);
        }
        return this.standardAddAll(collection);
    }

    public boolean remove(Object object) {
        if (this.iterating) {
            return this.toRemove.add((TravelingItem)object);
        }
        return this.delegate().remove(object);
    }

    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    void scheduleLoad(TravelingItem item) {
        this.delay = 10;
        this.toLoad.add(item);
    }

    private void loadScheduledItems() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.addAll(this.toLoad);
        this.toLoad.clear();
    }

    private void addScheduledItems() {
        this.addAll(this.toAdd);
        this.toAdd.clear();
    }

    public boolean scheduleRemoval(TravelingItem item) {
        return this.toRemove.add(item);
    }

    public boolean unscheduleRemoval(TravelingItem item) {
        return this.toRemove.remove(item);
    }

    void removeScheduledItems() {
        for (TravelingItem i : this.toRemove) {
            i.cleanup();
            this.items.remove(i);
        }
        this.toRemove.clear();
    }

    void flush() {
        this.loadScheduledItems();
        this.addScheduledItems();
        this.removeScheduledItems();
    }

    public Iterator<TravelingItem> iterator() {
        return this.items.iterator();
    }

    public void clear() {
        if (this.iterating) {
            this.toRemove.addAll((Collection<TravelingItem>)((Object)this));
        } else {
            this.items.clear();
        }
    }
}

