/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.ore;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.aobd.AOBD;
import ganymedes01.aobd.api.AOBDAddonManager;
import ganymedes01.aobd.blocks.AOBDBlock;
import ganymedes01.aobd.items.AOBDItem;
import ganymedes01.aobd.items.AOBDItemBlock;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.ModulesHandler;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class OreFinder {
    public static final HashMap<String, Item> itemMap = new HashMap();

    private static Collection<String> getMetalsWithPrefixes(String prefix1, String prefix2) {
        LinkedHashSet<String> ores = new LinkedHashSet<String>();
        for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith(prefix1) || OreDictionary.getOres((String)name).isEmpty()) continue;
            String oreName = name.substring(prefix1.length());
            for (String n : OreDictionary.getOreNames()) {
                if (!n.equals(prefix2 + oreName) || OreDictionary.getOres((String)n).isEmpty()) continue;
                ores.add(oreName);
            }
        }
        if (ores.contains("Aluminum") && ores.contains("Aluminium")) {
            ores.remove("Aluminum");
        }
        if (ores.contains("AluminumBrass") && ores.contains("AluminiumBrass")) {
            ores.remove("AluminumBrass");
        }
        return Collections.unmodifiableSet(ores);
    }

    public static void preInit() {
        Collection<String> ores = OreFinder.getMetalsWithPrefixes("ore", "ingot");
        for (String ore : ores) {
            Ore.newOre(ore);
        }
        if (CompatType.NETHER_ORES.isEnabled()) {
            for (String ore : OreFinder.getMetalsWithPrefixes("oreNether", "ingot")) {
                if (ores.contains(ore)) continue;
                Ore.newNetherOre(ore);
            }
        }
    }

    public static void initColours() {
        for (Ore ore : Ore.ores) {
            ore.setColour(OreFinder.getColour(ore.name()));
        }
    }

    public static void init() {
        for (CompatType compat : CompatType.values()) {
            OreFinder.generateItems(compat, compat.prefixes());
        }
        String[] items = AOBD.userDefinedItems.trim().split(",");
        if (items.length > 0) {
            for (String prefix : items) {
                if ((prefix = prefix.trim()).isEmpty()) continue;
                for (Ore ore : Ore.ores) {
                    String name = ore.name();
                    OreFinder.registerOre(prefix + name, new AOBDItem(prefix, ore));
                }
            }
        }
        AOBDAddonManager.passOreListToAddons(Ore.ores);
    }

    private static void generateItems(CompatType compat, String[] prefixes) {
        if (compat.isEnabled()) {
            for (Ore ore : Ore.ores) {
                String name = ore.name();
                if (!ore.isCompatEnabled(compat) || ModulesHandler.isOreBlacklisted(compat, name)) continue;
                for (String prefix : prefixes) {
                    String str = prefix.trim();
                    if (AOBDBlock.BLOCKS_PREFIXES.containsKey(str)) {
                        OreFinder.registerOre(str + name, new AOBDBlock(str, ore));
                        continue;
                    }
                    OreFinder.registerOre(str + name, new AOBDItem(str, ore));
                }
            }
        }
    }

    public static void registerOre(String ore, AOBDBlock block) {
        if (OreDictionary.getOres((String)ore).isEmpty()) {
            GameRegistry.registerBlock((Block)block, AOBDItemBlock.class, (String)ore);
            OreDictionary.registerOre((String)ore, (Block)block);
            itemMap.put(ore, Item.func_150898_a((Block)block));
        }
    }

    public static void registerOre(String ore, AOBDItem item) {
        if (OreDictionary.getOres((String)ore).isEmpty()) {
            GameRegistry.registerItem((Item)item, (String)ore);
            OreDictionary.registerOre((String)ore, (Item)item);
            itemMap.put(ore, item);
        }
    }

    private static int getStackColour(ItemStack stack, int pass) {
        if (Loader.isModLoaded((String)"gregtech")) {
            try {
                Class<?> cls = Class.forName("gregtech.api.items.GT_MetaGenerated_Item");
                Class<?> itemCls = stack.func_77973_b().getClass();
                if (cls.isAssignableFrom(itemCls)) {
                    Method m = itemCls.getMethod("getRGBa", ItemStack.class);
                    short[] rgba = (short[])m.invoke((Object)stack.func_77973_b(), stack);
                    return new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack.func_77973_b().func_82790_a(stack, pass);
    }

    private static Color getColour(String oreName) {
        ArrayList ores = OreDictionary.getOres((String)("ingot" + oreName));
        if (ores.isEmpty()) {
            return null;
        }
        Color colour = Ore.getDefaultOreColour(oreName);
        if (colour != null) {
            return colour;
        }
        LinkedHashSet<Object> colours = new LinkedHashSet<Object>();
        for (ItemStack stack : ores) {
            try {
                BufferedImage texture = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(OreFinder.getIconResource(stack)).func_110527_b());
                Color texColour = OreFinder.getAverageColour(texture);
                colours.add(texColour);
                for (int i = 0; i < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++i) {
                    int c = OreFinder.getStackColour(stack, i);
                    if (c == 0xFFFFFF) continue;
                    colours.add(new Color(c));
                    colours.remove(texColour);
                }
            }
            catch (Exception e) {
            }
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (Color color : colours) {
            red += (float)color.getRed();
            green += (float)color.getGreen();
            blue += (float)color.getBlue();
        }
        float count = colours.size();
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static Color getAverageColour(BufferedImage image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                Color c = new Color(image.getRGB(i, j));
                if (c.getAlpha() != 255 || c.getRed() <= 10 && c.getBlue() <= 10 && c.getGreen() <= 10) continue;
                red += (float)c.getRed();
                green += (float)c.getGreen();
                blue += (float)c.getBlue();
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static String getIconName(ItemStack stack) {
        IIcon icon = stack.func_77973_b().func_77617_a(stack.func_77960_j());
        if (icon != null) {
            return icon.func_94215_i();
        }
        return null;
    }

    private static ResourceLocation getIconResource(ItemStack stack) {
        String iconName = OreFinder.getIconName(stack);
        if (iconName == null) {
            return null;
        }
        String string = "minecraft";
        int colonIndex = iconName.indexOf(58);
        if (colonIndex >= 0) {
            if (colonIndex > 1) {
                string = iconName.substring(0, colonIndex);
            }
            iconName = iconName.substring(colonIndex + 1, iconName.length());
        }
        string = string.toLowerCase();
        iconName = "textures/items/" + iconName + ".png";
        return new ResourceLocation(string, iconName);
    }
}

