/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers.Tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import vswe.stevescarts.Blocks.ModBlocks;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.BlockCoord;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleDrillIntelligence;
import vswe.stevescarts.Modules.Addons.ModuleIncinerator;
import vswe.stevescarts.Modules.Addons.ModuleLiquidSensors;
import vswe.stevescarts.Modules.Addons.ModuleOreTracker;
import vswe.stevescarts.Modules.IActivatorModule;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Modules.Storages.Chests.ModuleChest;
import vswe.stevescarts.Modules.Workers.Tools.ModuleTool;

public abstract class ModuleDrill
extends ModuleTool
implements IActivatorModule {
    private ModuleDrillIntelligence intelligence;
    private ModuleLiquidSensors liquidsensors;
    private ModuleOreTracker tracker;
    private byte sensorLight = 1;
    private float drillRotation;
    private int miningCoolDown;
    private int[] buttonRect = new int[]{15, 30, 24, 12};

    public ModuleDrill(MinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 50;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleDrillIntelligence) {
                this.intelligence = (ModuleDrillIntelligence)module;
            }
            if (module instanceof ModuleLiquidSensors) {
                this.liquidsensors = (ModuleLiquidSensors)module;
            }
            if (!(module instanceof ModuleOreTracker)) continue;
            this.tracker = (ModuleOreTracker)module;
        }
    }

    @Override
    public boolean work() {
        if (!this.isDrillEnabled()) {
            this.stopDrill();
            this.stopWorking();
            return false;
        }
        if (!this.doPreWork()) {
            this.stopDrill();
            this.stopWorking();
        }
        if (this.isBroken()) {
            return false;
        }
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        int[] range = this.mineRange();
        for (int holeY = range[1]; holeY >= range[0]; --holeY) {
            for (int holeX = -this.blocksOnSide(); holeX <= this.blocksOnSide(); ++holeX) {
                int coordZ;
                int coordY;
                int coordX;
                if (this.intelligence != null && !this.intelligence.isActive(holeX + this.blocksOnSide(), holeY, range[2], x > this.getCart().x() || z < this.getCart().z()) || !this.mineBlockAndRevive(coordX = x + (this.getCart().z() != z ? holeX : 0), coordY = y + holeY, coordZ = z + (this.getCart().x() != x ? holeX : 0), next, holeX, holeY)) continue;
                return true;
            }
        }
        if (this.countsAsAir(x, y + range[0], z) && !this.isValidForTrack(x, y + range[0], z, true) && this.mineBlockAndRevive(x, y + (range[0] - 1), z, next, 0, range[0] - 1)) {
            return true;
        }
        this.stopWorking();
        this.stopDrill();
        return false;
    }

    protected int[] mineRange() {
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        int yTarget = this.getCart().getYTarget();
        if (BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)x, (int)y, (int)z) || BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)x, (int)(y - 1), (int)z)) {
            return new int[]{0, this.blocksOnTop() - 1, 1};
        }
        if (y > yTarget) {
            return new int[]{-1, this.blocksOnTop() - 1, 1};
        }
        if (y < yTarget) {
            return new int[]{1, this.blocksOnTop() + 1, 0};
        }
        return new int[]{0, this.blocksOnTop() - 1, 1};
    }

    protected abstract int blocksOnTop();

    protected abstract int blocksOnSide();

    public int getAreaWidth() {
        return this.blocksOnSide() * 2 + 1;
    }

    public int getAreaHeight() {
        return this.blocksOnTop();
    }

    private boolean mineBlockAndRevive(int coordX, int coordY, int coordZ, Vec3 next, int holeX, int holeY) {
        if (this.mineBlock(coordX, coordY, coordZ, next, holeX, holeY, false)) {
            return true;
        }
        if (this.isDead()) {
            this.revive();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean mineBlock(int coordX, int coordY, int coordZ, Vec3 next, int holeX, int holeY, boolean flag) {
        int fortune;
        BlockCoord start;
        BlockCoord target;
        if (this.tracker != null && (target = this.tracker.findBlockToMine(this, start = new BlockCoord(coordX, coordY, coordZ))) != null) {
            coordX = target.getX();
            coordY = target.getY();
            coordZ = target.getZ();
        }
        Object valid = this.isValidBlock(coordX, coordY, coordZ, holeX, holeY, flag);
        TileEntity storage = null;
        if (valid instanceof TileEntity) {
            storage = (TileEntity)valid;
        } else if (valid == null) {
            return false;
        }
        Block b = this.getCart().field_70170_p.func_147439_a(coordX, coordY, coordZ);
        int m = this.getCart().field_70170_p.func_72805_g(coordX, coordY, coordZ);
        float h = b.func_149712_f(this.getCart().field_70170_p, coordX, coordY, coordZ);
        if (h < 0.0f) {
            h = 0.0f;
        }
        if (storage != null) {
            for (int i = 0; i < ((IInventory)storage).func_70302_i_(); ++i) {
                ItemStack iStack = ((IInventory)storage).func_70301_a(i);
                if (iStack == null) continue;
                if (!this.minedItem(iStack, next)) return false;
                ((IInventory)storage).func_70299_a(i, null);
            }
        }
        int n = fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
        if (this.shouldSilkTouch(b, coordX, coordY, coordZ, m)) {
            ItemStack item = this.getSilkTouchedItem(b, m);
            if (item != null && !this.minedItem(item, next)) return false;
            this.getCart().field_70170_p.func_147468_f(coordX, coordY, coordZ);
        } else if (b.getDrops(this.getCart().field_70170_p, coordX, coordY, coordZ, m, fortune).size() != 0) {
            ArrayList stacks = b.getDrops(this.getCart().field_70170_p, coordX, coordY, coordZ, m, fortune);
            boolean shouldRemove = false;
            for (int i = 0; i < stacks.size(); ++i) {
                if (!this.minedItem((ItemStack)stacks.get(i), next)) {
                    return false;
                }
                shouldRemove = true;
            }
            if (shouldRemove) {
                this.getCart().field_70170_p.func_147468_f(coordX, coordY, coordZ);
            }
        } else {
            this.getCart().field_70170_p.func_147468_f(coordX, coordY, coordZ);
        }
        this.damageTool(1 + (int)h);
        this.startWorking(this.getTimeToMine(h));
        this.startDrill();
        return true;
    }

    protected boolean minedItem(ItemStack iStack, Vec3 Coords) {
        EntityItem entityitem;
        if (iStack == null || iStack.field_77994_a <= 0) {
            return true;
        }
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleIncinerator)) continue;
            ((ModuleIncinerator)module).incinerate(iStack);
            if (iStack.field_77994_a > 0) continue;
            return true;
        }
        int size = iStack.field_77994_a;
        this.getCart().addItemToChest(iStack);
        if (iStack.field_77994_a == 0) {
            return true;
        }
        boolean hasChest = false;
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleChest)) continue;
            hasChest = true;
            break;
        }
        if (hasChest) {
            if (iStack.field_77994_a != size) {
                entityitem = new EntityItem(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
                entityitem.field_70159_w = (float)((double)this.getCart().z() - Coords.field_72449_c) / 10.0f;
                entityitem.field_70181_x = 0.15f;
                entityitem.field_70179_y = (float)((double)this.getCart().x() - Coords.field_72450_a) / 10.0f;
                this.getCart().field_70170_p.func_72838_d((Entity)entityitem);
                return true;
            }
            return false;
        }
        entityitem = new EntityItem(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
        entityitem.field_70159_w = (float)((double)this.getCart().x() - Coords.field_72450_a) / 10.0f;
        entityitem.field_70181_x = 0.15f;
        entityitem.field_70179_y = (float)((double)this.getCart().z() - Coords.field_72449_c) / 10.0f;
        this.getCart().field_70170_p.func_72838_d((Entity)entityitem);
        return true;
    }

    private int getTimeToMine(float hardness) {
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        return (int)((double)(this.getTimeMult() * hardness) / Math.pow(1.3f, efficiency)) + (this.liquidsensors != null ? 2 : 0);
    }

    protected abstract float getTimeMult();

    public Object isValidBlock(int x, int y, int z, int i, int j, boolean flag) {
        TileEntity tileentity;
        if (!flag && BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)x, (int)y, (int)z) || BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)x, (int)(y + 1), (int)z)) {
            return null;
        }
        Block b = this.getCart().field_70170_p.func_147439_a(x, y, z);
        int m = this.getCart().field_70170_p.func_72805_g(x, y, z);
        if (b == null) {
            return null;
        }
        if (b == Blocks.field_150350_a) {
            return null;
        }
        if (b == Blocks.field_150357_h) {
            return null;
        }
        if (b instanceof BlockLiquid) {
            return null;
        }
        if (b.func_149712_f(this.getCart().field_70170_p, x, y, z) < 0.0f) {
            return null;
        }
        if (!(i == 0 && j <= 0 || b != Blocks.field_150478_aa && b != Blocks.field_150488_af && b != Blocks.field_150429_aA && b != Blocks.field_150437_az && b != Blocks.field_150416_aS && b != Blocks.field_150413_aR && b != Blocks.field_150455_bV && b != Blocks.field_150441_bU && b != ModBlocks.MODULE_TOGGLER.getBlock())) {
            return null;
        }
        if (b instanceof BlockContainer && (tileentity = this.getCart().field_70170_p.func_147438_o(x, y, z)) != null && IInventory.class.isInstance(tileentity)) {
            if (i != 0 || j > 0) {
                return null;
            }
            return tileentity;
        }
        if (this.liquidsensors != null) {
            if (this.liquidsensors.isDangerous(this, x, y, z, 0, 1, 0) || this.liquidsensors.isDangerous(this, x, y, z, 1, 0, 0) || this.liquidsensors.isDangerous(this, x, y, z, -1, 0, 0) || this.liquidsensors.isDangerous(this, x, y, z, 0, 0, 1) || this.liquidsensors.isDangerous(this, x, y, z, 0, 0, -1)) {
                this.sensorLight = (byte)3;
                return null;
            }
            this.sensorLight = (byte)2;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().hasFuel() && this.isMining() || this.miningCoolDown < 10) {
            this.drillRotation = (float)((double)(this.drillRotation + 0.03f * (float)(10 - this.miningCoolDown)) % (Math.PI * 2));
            this.miningCoolDown = this.isMining() ? 0 : ++this.miningCoolDown;
        }
        if (!this.getCart().field_70170_p.field_72995_K && this.liquidsensors != null) {
            byte data = this.sensorLight;
            if (this.isDrillSpinning()) {
                data = (byte)(data | 4);
            }
            this.liquidsensors.getInfoFromDrill(data);
            this.sensorLight = 1;
        }
    }

    protected void startDrill() {
        this.updateDw(0, 1);
    }

    protected void stopDrill() {
        this.updateDw(0, 0);
    }

    protected boolean isMining() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return this.getDw(0) != 0;
    }

    protected boolean isDrillSpinning() {
        return this.isMining() || this.miningCoolDown < 10;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
        this.addDw(1, 1);
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    public float getDrillRotation() {
        return this.drillRotation;
    }

    private boolean isDrillEnabled() {
        return this.getDw(1) != 0;
    }

    public void setDrillEnabled(boolean val) {
        this.updateDw(1, val ? 1 : 0);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.setDrillEnabled(!this.isDrillEnabled());
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.TOOLS.DRILL.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        super.drawBackground(gui, x, y);
        ResourceHelper.bindResource("/gui/drill.png");
        int imageID = this.isDrillEnabled() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        super.drawMouseOver(gui, x, y);
        this.drawStringOnMouseOver(gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        return Localization.MODULES.TOOLS.TOGGLE.translate(this.isDrillEnabled() ? "1" : "0");
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74757_a(this.generateNBTName("DrillEnabled", id), this.isDrillEnabled());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setDrillEnabled(tagCompound.func_74767_n(this.generateNBTName("DrillEnabled", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setDrillEnabled(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setDrillEnabled(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isDrillEnabled();
    }
}

