/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class Genepool {
    public static final int slotBee = 0;
    public static final int[] slotReserve = new int[]{1, 2, 3, 4, 5, 6};
    public static final int tankDNA = 0;
    public static final int tankEthanol = 1;
    public static final int slotEnzyme = 7;

    public static class ComponentGenepoolFX
    extends MachineComponent
    implements IRender.RandomDisplayTick,
    IRender.DisplayTick {
        public ComponentGenepoolFX(IMachine machine) {
            super(machine);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRandomDisplayTick(World world, int x, int y, int z, Random rand) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onDisplayTick(World world, int x, int y, int z, Random rand) {
            if (rand.nextFloat() < 1.0f && this.getUtil().getProcess().isInProgress()) {
                BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.3 + rand.nextDouble() * 0.4, y + 1, (double)z + 0.3 + rand.nextDouble() * 0.4, 0.0, 0.0, 0.0){
                    double axisX;
                    double axisZ;
                    double angle;
                    {
                        this.axisX = 0.0;
                        this.axisZ = 0.0;
                        this.angle = 0.0;
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = (double)this.field_70146_Z.nextFloat() * 0.01;
                        this.field_70547_e = 25;
                        this.axisX = this.field_70165_t;
                        this.axisZ = this.field_70161_v;
                        this.field_70545_g = 0.0f;
                        this.angle = this.field_70146_Z.nextDouble() * 2.0 * 3.1415;
                        this.field_70145_X = true;
                        this.func_70538_b(0.4f + 0.6f * this.field_70146_Z.nextFloat(), 0.6f * this.field_70146_Z.nextFloat(), 0.6f + 0.4f * this.field_70146_Z.nextFloat());
                    }

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
                    }

                    public int func_70537_b() {
                        return 0;
                    }
                });
            }
        }
    }

    public static class ComponentGenepoolLogic
    extends ComponentProcessSetCost
    implements IProcess {
        float enzymePerProcess = 0.25f;
        float ethanolPerProcess = 50.0f;
        private float ethanolDrain = 0.0f;

        public ComponentGenepoolLogic(Machine machine) {
            super(machine, 8000, 400);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(0)) {
                return new ErrorState.NoItem("No Individual", 0);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!this.getUtil().spaceInTank(0, this.getDNAAmount(this.getUtil().getStack(0)))) {
                return new ErrorState.NoSpace("Not enough room in Tank", new int[]{0});
            }
            if (!this.getUtil().liquidInTank(1, 1)) {
                return new ErrorState.InsufficientLiquid("Not enough Ethanol", 1);
            }
            if (this.getUtil().getSlotCharge(7) == 0.0f) {
                return new ErrorState.NoItem("Insufficient Enzyme", 7);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            super.onFinishTask();
            int amount = this.getDNAAmount(this.getUtil().getStack(0));
            this.getUtil().fillTank(0, GeneticLiquid.RawDNA.get(amount));
            this.getUtil().deleteStack(0);
        }

        private int getDNAAmount(ItemStack stack) {
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
            if (root == null) {
                return 10;
            }
            if (root == Binnie.Genetics.getBeeRoot()) {
                if (Binnie.Genetics.getBeeRoot().isDrone(stack)) {
                    return 10;
                }
                if (Binnie.Genetics.getBeeRoot().isMated(stack)) {
                    return 50;
                }
                return 30;
            }
            return 10;
        }

        @Override
        protected void onTickTask() {
            this.ethanolDrain += (float)this.getDNAAmount(this.getUtil().getStack(0)) * 1.2f * this.getProgressPerTick() / 100.0f;
            if (this.ethanolDrain >= 1.0f) {
                this.getUtil().drainTank(1, 1);
                this.ethanolDrain -= 1.0f;
            }
            this.getMachine().getInterface(IChargedSlots.class).alterCharge(7, -this.enzymePerProcess * this.getProgressPerTick() / 100.0f);
        }
    }

    public static class PackageGenepool
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageGenepool() {
            super("genepool", GeneticsTexture.Genepool, 12661942, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Genepool);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(7, "enzyme");
            inventory.getSlot(7).setValidator((Validator)new SlotValidator.Item(GeneticsItems.Enzyme.get(1), ModuleMachine.IconEnzyme));
            inventory.getSlot(7).forbidExtraction();
            inventory.addSlot(0, "process");
            inventory.getSlot(0).setValidator((Validator)new SlotValidator.Individual());
            inventory.getSlot(0).setReadOnly();
            inventory.getSlot(0).forbidExtraction();
            inventory.addSlotArray(slotReserve, "input");
            for (InventorySlot slot : inventory.getSlots(slotReserve)) {
                slot.setValidator((Validator)new SlotValidator.Individual());
                slot.forbidExtraction();
            }
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(0, "output", 2000);
            tanks.getTankSlot(0).setReadOnly();
            tanks.addTank(1, "input", 1000);
            tanks.getTankSlot(1).forbidExtraction();
            tanks.getTankSlot(1).setValidator((Validator)new TankValidator(){

                @Override
                public String getTooltip() {
                    return "Ethanol";
                }

                @Override
                public boolean isValid(FluidStack stack) {
                    return stack.getFluid().getName() == "bioethanol";
                }
            });
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotReserve, 0, 1);
            new ComponentPowerReceptor(machine, 1600);
            new ComponentGenepoolLogic(machine);
            ComponentChargedSlots chargedSlots = new ComponentChargedSlots(machine);
            chargedSlots.addCharge(7);
            new ComponentGenepoolFX(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

