/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.core.BinnieCore;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.IDrinkLiquid;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CocktailRenderer
implements IItemRenderer {
    private void renderCocktail(RenderBlocks renderBlocks, ItemStack item, float p, float q, float r) {
        RenderItem renderItem = new RenderItem();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Glassware glass = ExtraTrees.drink.getGlassware(item);
        FluidStack fluid = ExtraTrees.drink.getFluid(item);
        IDrinkLiquid drink = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
        this.setColor(0xFFFFFF, 0.8f);
        renderItem.func_94149_a(0, 0, glass.glass, 16, 16);
        if (drink != null) {
            this.setColor(drink.getColour(), 1.2f * drink.getTransparency() + 0.3f);
            IIcon icon = glass.contents;
            float amount = (float)fluid.amount / (float)glass.getVolume();
            float level = glass.getContentHeight() * (1.0f - amount);
            float gapAtTop = 1.0f - (glass.getContentBottom() + glass.getContentHeight());
            float x = 0.0f;
            float y = 16.0f * (gapAtTop + level);
            float w = 16.0f;
            float h = 16.0f - y;
            float minV = icon.func_94207_b((double)y);
            float maxV = icon.func_94207_b(16.0);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(x + 0.0f), (double)(y + h), (double)renderItem.field_77023_b, (double)icon.func_94209_e(), (double)maxV);
            tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)renderItem.field_77023_b, (double)icon.func_94212_f(), (double)maxV);
            tessellator.func_78374_a((double)(x + w), (double)(y + 0.0f), (double)renderItem.field_77023_b, (double)icon.func_94212_f(), (double)minV);
            tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)renderItem.field_77023_b, (double)icon.func_94209_e(), (double)minV);
            tessellator.func_78381_a();
        }
        GL11.glDisable((int)3042);
    }

    private void setColor(int i1, float alpha) {
        float f = (float)(i1 >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i1 >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i1 & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)(alpha > 1.0f ? 1.0f : alpha));
    }

    private void renderFace(Tessellator tessellator, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                tessellator.func_78377_a(0.0, 0.0, 0.0);
                tessellator.func_78377_a(0.0, 0.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 1.0);
                tessellator.func_78377_a(1.0, 0.0, 0.0);
            }
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                if (type == IItemRenderer.ItemRenderType.ENTITY) {
                    GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)-0.0f);
                }
                TextureManager texturemanager = BinnieCore.proxy.getMinecraftInstance().func_110434_K();
                Glassware glass = ExtraTrees.drink.getGlassware(item);
                FluidStack fluid = ExtraTrees.drink.getFluid(item);
                IIcon iicon = glass.glass;
                float f = iicon.func_94209_e();
                float f1 = iicon.func_94212_f();
                float f2 = iicon.func_94206_g();
                float f3 = iicon.func_94210_h();
                texturemanager.func_110577_a(texturemanager.func_130087_a(item.func_94608_d()));
                TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                this.setColor(0xFFFFFF, 0.8f);
                IDrinkLiquid drink = fluid == null ? null : DrinkManager.getLiquid(fluid.getFluid());
                this.setColor(0xFFFFFF, 0.8f);
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f, (float)f3, (int)iicon.func_94211_a(), (int)iicon.func_94216_b(), (float)0.0625f);
                if (drink == null) break;
                this.setColor(drink.getColour(), 1.2f * drink.getTransparency() + 0.3f);
                iicon = glass.contents;
                IIcon icon = glass.contents;
                float amount = (float)fluid.amount / (float)glass.getVolume();
                float level = glass.getContentHeight() * (1.0f - amount);
                float gapAtTop = 1.0f - (glass.getContentBottom() + glass.getContentHeight());
                float x = 0.0f;
                float y = 1.0f * (gapAtTop + level);
                float w = 1.0f;
                float h = 1.0f - y;
                float minV = icon.func_94207_b((double)(y * 16.0f));
                float maxV = icon.func_94207_b(16.0);
                float minU = icon.func_94209_e();
                float maxU = icon.func_94212_f();
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                tessellator.func_78382_b();
                tessellator.func_78374_a(0.0, 1.0 - (double)y, -0.03125, (double)maxU, (double)minV);
                tessellator.func_78374_a(1.0, 1.0 - (double)y, -0.03125, (double)minU, (double)minV);
                tessellator.func_78374_a(1.0, 0.0, -0.03125, (double)minU, (double)maxV);
                tessellator.func_78374_a(0.0, 0.0, -0.03125, (double)maxU, (double)maxV);
                tessellator.func_78381_a();
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                tessellator.func_78382_b();
                tessellator.func_78374_a(0.0, 1.0 - (double)y, -0.03125, (double)maxU, (double)minV);
                tessellator.func_78374_a(0.0, 0.0, -0.03125, (double)maxU, (double)maxV);
                tessellator.func_78374_a(1.0, 0.0, -0.03125, (double)minU, (double)maxV);
                tessellator.func_78374_a(1.0, 1.0 - (double)y, -0.03125, (double)minU, (double)minV);
                tessellator.func_78381_a();
                break;
            }
            case INVENTORY: {
                this.renderCocktail((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
        }
    }

    public void renderItemIn2DPercentage(Tessellator tesselator, float maxU, float minV, float minU, float maxV, int width, int height, float depth, float percent) {
        float f9;
        float f8;
        float f7;
        int k;
        maxV = minV + (maxV - minV) * 1.0f;
        tesselator.func_78382_b();
        tesselator.func_78375_b(0.0f, 0.0f, 1.0f);
        tesselator.func_78374_a(0.0, 0.0, 0.0, (double)maxU, (double)maxV);
        tesselator.func_78374_a(1.0, 0.0, 0.0, (double)minU, (double)maxV);
        tesselator.func_78374_a(1.0, 1.0, 0.0, (double)minU, (double)minV);
        tesselator.func_78374_a(0.0, 1.0, 0.0, (double)maxU, (double)minV);
        tesselator.func_78381_a();
        tesselator.func_78382_b();
        tesselator.func_78375_b(0.0f, 0.0f, -1.0f);
        tesselator.func_78374_a(0.0, (double)percent, (double)(0.0f - depth), (double)maxU, (double)minV);
        tesselator.func_78374_a(1.0, (double)percent, (double)(0.0f - depth), (double)minU, (double)minV);
        tesselator.func_78374_a(1.0, 0.0, (double)(0.0f - depth), (double)minU, (double)maxV);
        tesselator.func_78374_a(0.0, 0.0, (double)(0.0f - depth), (double)maxU, (double)maxV);
        tesselator.func_78381_a();
        float f5 = 0.5f * (maxU - minU) / (float)width;
        float f6 = 0.5f * (maxV - minV) / (float)height;
        tesselator.func_78382_b();
        tesselator.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = maxU + (minU - maxU) * f7 - f5;
            tesselator.func_78374_a((double)f7, 0.0, (double)(0.0f - depth), (double)f8, (double)maxV);
            tesselator.func_78374_a((double)f7, 0.0, 0.0, (double)f8, (double)maxV);
            tesselator.func_78374_a((double)f7, 1.0, 0.0, (double)f8, (double)minV);
            tesselator.func_78374_a((double)f7, 1.0, (double)(0.0f - depth), (double)f8, (double)minV);
        }
        tesselator.func_78381_a();
        tesselator.func_78382_b();
        tesselator.func_78375_b(1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = maxU + (minU - maxU) * f7 - f5;
            f9 = f7 + 1.0f / (float)width;
            tesselator.func_78374_a((double)f9, 1.0, (double)(0.0f - depth), (double)f8, (double)minV);
            tesselator.func_78374_a((double)f9, 1.0, 0.0, (double)f8, (double)minV);
            tesselator.func_78374_a((double)f9, 0.0, 0.0, (double)f8, (double)maxV);
            tesselator.func_78374_a((double)f9, 0.0, (double)(0.0f - depth), (double)f8, (double)maxV);
        }
        tesselator.func_78381_a();
        tesselator.func_78382_b();
        tesselator.func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = maxV + (minV - maxV) * f7 - f6;
            f9 = f7 + 1.0f / (float)height;
            tesselator.func_78374_a(0.0, (double)f9, 0.0, (double)maxU, (double)f8);
            tesselator.func_78374_a(1.0, (double)f9, 0.0, (double)minU, (double)f8);
            tesselator.func_78374_a(1.0, (double)f9, (double)(0.0f - depth), (double)minU, (double)f8);
            tesselator.func_78374_a(0.0, (double)f9, (double)(0.0f - depth), (double)maxU, (double)f8);
        }
        tesselator.func_78381_a();
        tesselator.func_78382_b();
        tesselator.func_78375_b(0.0f, -1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = maxV + (minV - maxV) * f7 - f6;
            tesselator.func_78374_a(1.0, (double)f7, 0.0, (double)minU, (double)f8);
            tesselator.func_78374_a(0.0, (double)f7, 0.0, (double)maxU, (double)f8);
            tesselator.func_78374_a(0.0, (double)f7, (double)(0.0f - depth), (double)maxU, (double)f8);
            tesselator.func_78374_a(1.0, (double)f7, (double)(0.0f - depth), (double)minU, (double)f8);
        }
        tesselator.func_78381_a();
    }
}

