/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.scroll;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.ControlScroll;
import binnie.craftgui.controls.scroll.IControlScrollable;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.events.EventHandler;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.resource.minecraft.CraftGUITexture;

public class ControlScrollBar
extends Control {
    protected final IControlScrollable scrollable;

    public ControlScrollBar(ControlScroll parent) {
        this(parent, 0.0f, 0.0f, parent.getSize().x(), parent.getSize().y(), parent.getScrollableWidget());
    }

    public ControlScrollBar(IWidget parent, float x, float y, float w, float h, IControlScrollable scrollable2) {
        super(parent, x, y, w, h);
        this.scrollable = scrollable2;
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler((EventHandler)new EventMouse.Drag.Handler(){

            @Override
            public void onEvent(EventMouse.Drag event) {
                ControlScrollBar.this.scrollable.movePercentage(event.getDy() / (ControlScrollBar.this.h() - ControlScrollBar.this.getBarHeight()));
            }
        });
        this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                float shownPercentage = ControlScrollBar.this.scrollable.getPercentageShown();
                float percentageIndex = ControlScrollBar.this.scrollable.getPercentageIndex();
                float minPercent = (1.0f - shownPercentage) * percentageIndex;
                float maxPercent = minPercent + shownPercentage;
                float clickedPercentage = ControlScrollBar.this.getRelativeMousePosition().y() / (ControlScrollBar.this.h() - 2.0f);
                if ((clickedPercentage = Math.max(Math.min(clickedPercentage, 1.0f), 0.0f)) > maxPercent) {
                    ControlScrollBar.this.scrollable.setPercentageIndex((clickedPercentage - shownPercentage) / (1.0f - shownPercentage));
                }
                if (clickedPercentage < minPercent) {
                    ControlScrollBar.this.scrollable.setPercentageIndex(clickedPercentage / (1.0f - shownPercentage));
                }
            }
        });
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public boolean isEnabled() {
        return this.scrollable.getPercentageShown() < 0.99f;
    }

    public float getBarHeight() {
        return this.h() * this.scrollable.getPercentageShown();
    }

    protected IArea getRenderArea() {
        float height = this.getBarHeight();
        if (height < 6.0f) {
            height = 6.0f;
        }
        float yOffset = (float)((int)this.h() - (int)this.getBarHeight()) * this.scrollable.getPercentageIndex();
        return new IArea(0.0f, yOffset, this.getSize().x(), height);
    }

    @Override
    public void onRenderBackground() {
        IArea renderArea = this.getRenderArea();
        CraftGUITexture texture = CraftGUITexture.ScrollDisabled;
        if (this.isMouseOver()) {
            texture = CraftGUITexture.ScrollHighlighted;
        } else if (this.isEnabled()) {
            texture = CraftGUITexture.Scroll;
        }
        CraftGUI.Render.texture((Object)texture, renderArea);
    }
}

