/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import openmods.calc.BinaryFunction;
import openmods.calc.Environment;
import openmods.calc.Frame;
import openmods.calc.ICallable;
import openmods.calc.SingleReturnCallable;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class LibFunctional {
    public static void register(Environment<TypedValue> env) {
        TypedValue nullValue = env.nullValue();
        final TypeDomain typeDomain = nullValue.domain;
        env.setGlobalSymbol("curry", CallableValue.wrap(typeDomain, (ICallable<TypedValue>)new SingleReturnCallable<TypedValue>(){

            @Override
            public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
                int argCount = argumentsCount.get();
                Preconditions.checkState((argCount > 0 ? 1 : 0) != 0, (Object)"Expected more than one arg for 'curry' function");
                Stack<TypedValue> stack = frame.stack();
                Stack<TypedValue> argsStack = stack.substack(argCount - 1);
                ArrayList args = Lists.newArrayList(argsStack);
                argsStack.clear();
                TypedValue target = stack.pop();
                if (target.value instanceof PartialCallable) {
                    return ((PartialCallable)target.value).expand(args).selfValue(typeDomain);
                }
                Preconditions.checkState((boolean)MetaObjectUtils.isCallable(target), (String)"Value %s is not callable", (Object[])new Object[]{target});
                return new PartialCallable(target, args).selfValue(typeDomain);
            }
        }));
        env.setGlobalSymbol("chain", CallableValue.wrap(typeDomain, (ICallable<TypedValue>)new BinaryFunction.Direct<TypedValue>(){

            @Override
            protected TypedValue call(TypedValue left, TypedValue right) {
                Preconditions.checkState((boolean)MetaObjectUtils.isCallable(right), (String)"Value %s is not callable", (Object[])new Object[]{right});
                if (left.value instanceof ChainedCallable) {
                    return ((ChainedCallable)left.value).expand(right).selfValue(typeDomain);
                }
                Preconditions.checkState((boolean)MetaObjectUtils.isCallable(left), (String)"Value %s is not callable", (Object[])new Object[]{left});
                return new ChainedCallable((List<TypedValue>)ImmutableList.of((Object)left, (Object)right)).selfValue(typeDomain);
            }
        }));
        env.setGlobalSymbol("id", new CallableValue(){

            @Override
            public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                if (argumentsCount.isPresent() && returnsCount.isPresent()) {
                    Preconditions.checkArgument((argumentsCount.get() == returnsCount.get() ? 1 : 0) != 0, (String)"Expected %s returns, got %s", (Object[])new Object[]{argumentsCount.get(), returnsCount.get()});
                }
                int requiredArgs = 1;
                if (argumentsCount.isPresent()) {
                    requiredArgs = argumentsCount.get();
                }
                if (returnsCount.isPresent()) {
                    requiredArgs = returnsCount.get();
                }
                frame.stack().checkSizeIsAtLeast(requiredArgs);
            }
        }.selfValue(typeDomain));
    }

    private static class ChainedCallable
    extends CallableValue {
        private final List<TypedValue> chain;

        public ChainedCallable(List<TypedValue> chain) {
            this.chain = ImmutableList.copyOf(chain);
        }

        @Override
        public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
            Stack<TypedValue> stack = frame.stack().substack(argumentsCount.get());
            for (int i = this.chain.size() - 1; i >= 0; --i) {
                TypedValue target = this.chain.get(i);
                if (i == 0) {
                    MetaObjectUtils.call(frame, target, argumentsCount, returnsCount);
                    continue;
                }
                MetaObjectUtils.call(frame, target, argumentsCount, OptionalInt.ABSENT);
                argumentsCount = OptionalInt.of(stack.size());
            }
        }

        public ChainedCallable expand(TypedValue newPart) {
            ArrayList chain = Lists.newArrayList(this.chain);
            chain.add(newPart);
            return new ChainedCallable(chain);
        }
    }

    private static class PartialCallable
    extends CallableValue {
        private final TypedValue target;
        private final List<TypedValue> fixedArgs;

        public PartialCallable(TypedValue target, List<TypedValue> args) {
            this.target = target;
            this.fixedArgs = ImmutableList.copyOf(args);
        }

        @Override
        public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
            int givenArgsCount = argumentsCount.get();
            if (givenArgsCount > 0) {
                Stack<TypedValue> stack = frame.stack().substack(givenArgsCount);
                ImmutableList givenArgs = ImmutableList.copyOf(stack);
                stack.clear();
                stack.pushAll(this.fixedArgs);
                stack.pushAll((Collection<TypedValue>)givenArgs);
            } else {
                frame.stack().pushAll(this.fixedArgs);
            }
            MetaObjectUtils.call(frame, this.target, OptionalInt.of(this.fixedArgs.size() + givenArgsCount), returnsCount);
        }

        public PartialCallable expand(List<TypedValue> extraArgs) {
            ArrayList newArgs = Lists.newArrayList(this.fixedArgs);
            newArgs.addAll(extraArgs);
            return new PartialCallable(this.target, newArgs);
        }
    }
}

