/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.multipart;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.compat.multipart.MultipartSchematics;
import buildcraft.compat.multipart.SchematicPart;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.handler.MultipartProxy;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class SchematicMultipartBlock
extends SchematicBlock {
    private int rotation = 0;
    private LinkedList<Iterable<ItemStack>> requirements = new LinkedList();
    private NBTTagList parts;

    public boolean doNotUse() {
        return this.parts.func_74745_c() == 0;
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return false;
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        for (Map.Entry entry : MultipartSchematics.getSchematics(context, x, y, z)) {
            Iterable<ItemStack> stacks = ((SchematicPart)entry.getValue()).getRequirements((TMultiPart)entry.getKey());
            if (stacks == null) continue;
            this.requirements.add(stacks);
        }
    }

    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        for (Iterable iterable : this.requirements) {
            for (ItemStack stack : iterable) {
                requirements.add(stack);
            }
        }
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        this.parts = new NBTTagList();
        for (Map.Entry entry : MultipartSchematics.getSchematics(context, x, y, z)) {
            NBTTagCompound tag = ((SchematicPart)entry.getValue()).writePart((TMultiPart)entry.getKey());
            if (tag == null) continue;
            NBTTagCompound tag2 = new NBTTagCompound();
            tag2.func_74778_a("type", ((TMultiPart)entry.getKey()).getType());
            tag2.func_74782_a("part", (NBTBase)tag);
            this.parts.func_74742_a((NBTBase)tag2);
        }
    }

    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.func_74768_a("blockId", registry.getIdForBlock((Block)MultipartProxy.block()));
        for (int i = 0; i < this.parts.func_74745_c(); ++i) {
            NBTTagCompound partTag = this.parts.func_150305_b(i);
            NBTTagList items = new NBTTagList();
            for (ItemStack stack : this.requirements.get(i)) {
                NBTTagCompound itemTag = new NBTTagCompound();
                stack.func_77955_b(itemTag);
                registry.stackToRegistry(itemTag);
                items.func_74742_a((NBTBase)itemTag);
            }
            partTag.func_74782_a("items", (NBTBase)items);
        }
        nbt.func_74782_a("parts", (NBTBase)this.parts);
    }

    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        this.requirements.clear();
        this.parts = nbt.func_150295_c("parts", 10);
        for (int i = 0; i < this.parts.func_74745_c(); ++i) {
            NBTTagCompound tag = this.parts.func_150305_b(i);
            SchematicPart s = MultipartSchematics.getSchematic(tag.func_74779_i("type"));
            if (s == null || !s.isValid(tag.func_74775_l("part"))) {
                this.parts.func_74744_a(i);
                continue;
            }
            this.requirements.add(this.readItems(tag.func_150295_c("items", 10), registry));
        }
    }

    private LinkedList<ItemStack> readItems(NBTTagList itemList, MappingRegistry registry) {
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            try {
                NBTTagCompound sub = itemList.func_150305_b(i);
                if (sub.func_74762_e("id") >= 0) {
                    registry.stackToWorld(sub);
                    items.add(ItemStack.func_77949_a((NBTTagCompound)sub));
                    continue;
                }
                this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                continue;
            }
            catch (MappingNotFoundException e) {
                this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
            }
        }
        return items;
    }

    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        BlockCoord pos = new BlockCoord(x, y, z);
        for (int i = 0; i < this.parts.func_74745_c(); ++i) {
            NBTTagCompound tag = this.parts.func_150305_b(i);
            MultipartSchematics.getSchematic(tag.func_74779_i("type")).placePart(context, pos, tag.func_74775_l("part"), this.rotation);
        }
    }

    public void rotateLeft(IBuilderContext context) {
        ++this.rotation;
    }
}

