/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.minetweaker;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IProgrammingRecipe;
import buildcraft.core.lib.inventory.StackHelper;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.ProgrammingTable")
@ModOnly(value={"BuildCraft|Silicon"})
public class ProgrammingTable {
    @ZenMethod
    public static void addRecipe(IItemStack input, int energy, IItemStack[] options, @Optional boolean programmableOnce) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, energy, options, programmableOnce));
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final String id;
        private final ProgrammingRecipeMT progRecipe;

        public AddRecipeAction(IItemStack input, int energy, IItemStack[] options, boolean programmableOnce) {
            this.id = "MineTweaker:" + input.getName() + ":" + input.getDamage();
            this.progRecipe = new ProgrammingRecipeMT(this.id, energy, input, options, programmableOnce);
        }

        public void apply() {
            BuildcraftRecipeRegistry.programmingTable.addRecipe((IProgrammingRecipe)this.progRecipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftRecipeRegistry.programmingTable.removeRecipe(this.id);
        }

        public String describe() {
            return "Adding programming table recipe " + this.id;
        }

        public String describeUndo() {
            return "Removing programming table recipe " + this.id;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ProgrammingRecipeMT
    implements IProgrammingRecipe {
        private final String id;
        private final int energyCost;
        private final IItemStack input;
        private final List<ItemStack> options;
        private final boolean programmableOnce;

        public ProgrammingRecipeMT(String id, int energyCost, IItemStack input, IItemStack[] options, boolean programmableOnce) {
            this.id = id;
            this.energyCost = energyCost;
            this.input = input;
            this.options = new ArrayList<ItemStack>();
            for (IItemStack option : options) {
                this.options.add(MineTweakerMC.getItemStack((IItemStack)option));
            }
            this.programmableOnce = programmableOnce;
        }

        public String getId() {
            return this.id;
        }

        public List<ItemStack> getOptions(int w, int h) {
            return this.options;
        }

        public int getEnergyCost(ItemStack itemStack) {
            return this.energyCost;
        }

        public boolean canCraft(ItemStack stack) {
            if (this.input.matches(MineTweakerMC.getIItemStack((ItemStack)stack))) {
                return true;
            }
            if (!this.programmableOnce) {
                for (ItemStack option : this.options) {
                    if (!StackHelper.isEqualItem((ItemStack)option, (ItemStack)stack)) continue;
                    return true;
                }
            }
            return false;
        }

        public ItemStack craft(ItemStack input, ItemStack option) {
            return option.func_77946_l();
        }
    }
}

