/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeHooks;

public class ToolHelper {
    private static Class<?> HarvestTool = null;
    private static Class<?> DualHarvestTool = null;
    private static Method getHarvestType = null;
    private static Method getSecondHarvestType = null;
    public static boolean tinkersConstructLoaded = false;

    public static void init() {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                HarvestTool = Class.forName("tconstruct.library.tools.HarvestTool");
                DualHarvestTool = Class.forName("tconstruct.library.tools.DualHarvestTool");
                getHarvestType = HarvestTool.getDeclaredMethod("getHarvestType", new Class[0]);
                getSecondHarvestType = DualHarvestTool.getDeclaredMethod("getSecondHarvestType", new Class[0]);
                getHarvestType.setAccessible(true);
                getSecondHarvestType.setAccessible(true);
                tinkersConstructLoaded = true;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static boolean hasToolTag(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("InfiTool");
    }

    public static NBTTagCompound getToolTag(ItemStack tool) {
        NBTTagCompound tag = null;
        if (tool.func_77942_o()) {
            tag = tool.func_77978_p().func_74775_l("InfiTool");
        }
        return tag;
    }

    public static int getPrimaryHarvestLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("HarvestLevel");
    }

    public static int getSecondaryHarvestLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("HarvestLevel2");
    }

    public static Set<String> getToolClassesOf(ItemStack tool) {
        return tool.func_77973_b().getToolClasses(tool);
    }

    public static boolean isToolOfClass(ItemStack tool, String toolClass) {
        return ToolHelper.getToolClassesOf(tool).contains(toolClass);
    }

    public static boolean toolHasAnyToolClass(ItemStack tool) {
        return !ToolHelper.getToolClassesOf(tool).isEmpty();
    }

    public static boolean isToolEffectiveAgainst(ItemStack tool, Block block, int metadata, String effectiveToolClass) {
        if (tinkersConstructLoaded && HarvestTool.isInstance(tool.func_77973_b())) {
            Item item = tool.func_77973_b();
            ArrayList<String> harvestTypes = new ArrayList<String>();
            try {
                harvestTypes.add((String)getHarvestType.invoke((Object)item, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                tinkersConstructLoaded = false;
            }
            if (DualHarvestTool.isInstance(item)) {
                try {
                    harvestTypes.add((String)getSecondHarvestType.invoke((Object)item, new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    tinkersConstructLoaded = false;
                }
            }
            return harvestTypes.contains(effectiveToolClass);
        }
        return ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)metadata) || (ToolHelper.toolHasAnyToolClass(tool) ? ToolHelper.isToolOfClass(tool, effectiveToolClass) : tool.func_77973_b().getDigSpeed(tool, block, metadata) > 1.5f);
    }

    public static boolean canToolHarvestLevel(ItemStack tool, Block block, int metadata, int harvestLevel) {
        boolean canTinkersToolHarvestBlock = false;
        NBTTagCompound toolTag = ToolHelper.getToolTag(tool);
        if (toolTag != null) {
            int toolHarvestLevel = Math.max(ToolHelper.getPrimaryHarvestLevel(toolTag), ToolHelper.getSecondaryHarvestLevel(toolTag));
            canTinkersToolHarvestBlock = toolHarvestLevel >= harvestLevel;
        }
        return canTinkersToolHarvestBlock || ForgeHooks.canToolHarvestBlock((Block)block, (int)metadata, (ItemStack)tool);
    }

    public static boolean canToolHarvestBlock(ItemStack tool, Block block, int metadata) {
        return block.func_149688_o().func_76229_l() || tool.func_150998_b(block);
    }
}

