/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils.helpers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.api.client.ISkinDownloadCallback;
import ganymedes01.etfuturum.client.skins.PlayerModelManager;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.TileEntityBlockPlayerRenderer;
import ganymedes01.headcrumbs.utils.TextureUtils;
import ganymedes01.headcrumbs.utils.Utils;
import ganymedes01.headcrumbs.utils.helpers.HeadDropHelper;
import java.util.Random;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EtFuturumHelper
extends HeadDropHelper {
    public EtFuturumHelper() {
        super("etfuturum");
        this.typesMap.put("etfuturum.endermite", SkullTypes.endermite);
        if (this.isEnabled() && Headcrumbs.addPlayerHeadsAsDungeonLoot) {
            Random rand = new Random();
            int min = 1;
            int max = 1;
            int baseWeight = 3;
            Utils.addDungeonLoot(SkullTypes.guardian.getStack(), min, max, baseWeight + rand.nextInt(Headcrumbs.headsDungeonLootMaxWeight));
            Utils.addDungeonLoot(SkullTypes.guardianElder.getStack(), min, max, baseWeight + rand.nextInt(Headcrumbs.headsDungeonLootMaxWeight));
            Utils.addDungeonLoot(SkullTypes.shulker.getStack(), min, max, baseWeight + rand.nextInt(Headcrumbs.headsDungeonLootMaxWeight));
        }
    }

    @Override
    protected ItemStack getHeadForEntity(Entity entity) {
        ItemStack head = super.getHeadForEntity(entity);
        if (head != null) {
            return head;
        }
        String mobName = EntityList.func_75621_b((Entity)entity);
        if (mobName != null && mobName.equals("etfuturum.rabbit")) {
            String name = entity.func_70005_c_();
            if (name != null && name.equals("Toast")) {
                return SkullTypes.rabbitToast.getStack();
            }
            byte rabbitType = entity.func_70096_w().func_75683_a(18);
            switch (rabbitType) {
                case 0: {
                    return SkullTypes.rabbitBrown.getStack();
                }
                case 1: {
                    return SkullTypes.rabbitWhite.getStack();
                }
                case 2: {
                    return SkullTypes.rabbitBlack.getStack();
                }
                case 3: {
                    return SkullTypes.rabbitSplotched.getStack();
                }
                case 4: {
                    return SkullTypes.rabbitGold.getStack();
                }
                case 5: {
                    return SkullTypes.rabbitSalt.getStack();
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static SkinManager.SkinAvailableCallback getSkinDownloadCallback(final String name) {
        return new ISkinDownloadCallback(){

            public void func_152121_a(MinecraftProfileTexture.Type texType, ResourceLocation texture) {
                TextureUtils.textures.get(texType).put(name, texture);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static AbstractClientPlayer getPlayer(World world, GameProfile profile) {
        return new EtFuturumPlayerForRendering(world, profile);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isAlexModel(ResourceLocation texture) {
        return PlayerModelManager.isPlayerModelAlex((ResourceLocation)texture);
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Interface(iface="ganymedes01.etfuturum.api.client.ISkinDownloadCallback", modid="etfuturum")
    private static class EtFuturumPlayerForRendering
    extends TileEntityBlockPlayerRenderer.PlayerForRendering
    implements ISkinDownloadCallback {
        public EtFuturumPlayerForRendering(World world, GameProfile profile) {
            super(world, profile);
        }
    }
}

