/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.renderers;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.OpenGLHelper;
import ganymedes01.headcrumbs.renderers.TileEntityBlockSkullRenderer;
import ganymedes01.headcrumbs.utils.HeadUtils;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

@SideOnly(value=Side.CLIENT)
public class ItemSkullRender
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        boolean isVanilla;
        int skullType = stack.func_77960_j();
        if (skullType < 0 || skullType >= SkullTypes.values().length) {
            return;
        }
        GameProfile profile = null;
        boolean bl = isVanilla = stack.func_77973_b() == Items.field_151144_bL;
        if (stack.func_77942_o()) {
            profile = HeadUtils.getGameProfile(stack);
            if (isVanilla) {
                skullType = SkullTypes.player.ordinal();
                isVanilla = false;
            }
        }
        if (!isVanilla) {
            SkullTypes.values()[skullType].model().preRenderItem(profile, type);
        }
        switch (type) {
            case ENTITY: {
                this.renderSkull(-0.25f, -0.5f, -0.5f, skullType, profile, isVanilla);
                break;
            }
            case EQUIPPED: {
                this.renderSkull(0.5f, 0.0f, 0.0f, skullType, profile, isVanilla);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderSkull(0.5f, 0.35f, 0.25f, skullType, profile, isVanilla);
                break;
            }
            case INVENTORY: {
                OpenGLHelper.scale(1.5, 1.5, 1.5);
                this.renderSkull(0.75f, 0.3f, 0.5f, skullType, profile, isVanilla);
                break;
            }
        }
    }

    private void renderSkull(float x, float y, float z, int type, GameProfile name, boolean isVanilla) {
        OpenGLHelper.pushMatrix();
        OpenGLHelper.translate(x, y, z);
        if (isVanilla) {
            TileEntitySkullRenderer.field_147536_b.func_152674_a(0.0f, 0.0f, 0.0f, 0, 0.0f, type, name);
        } else {
            TileEntityBlockSkullRenderer.instance.renderHead(0.0f, 0.0f, 0.0f, 0, 0.0f, type, name);
        }
        OpenGLHelper.popMatrix();
    }
}

