/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.utils;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileUtils {
    public static <T extends TileEntity> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileClass.isInstance(tileEntity)) {
            return (T)((TileEntity)tileClass.cast(tileEntity));
        }
        return null;
    }

    public static void writeInventoryToNBT(NBTTagCompound compound, IInventory inventory) {
        NBTTagList items = new NBTTagList();
        for (byte slot = 0; slot < inventory.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inventory.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", slot);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("InventoryItems", (NBTBase)items);
    }

    public static void readInventoryFromNBT(NBTTagCompound compound, IInventory inventory) {
        NBTTagList items = compound.func_150295_c("InventoryItems", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            inventory.func_70299_a((int)slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    public static void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70304_b(i);
                if (stack == null) continue;
                TileUtils.dropItemStack(stack, world, x, y, z);
            }
        }
    }

    public static void dropItemStack(ItemStack stack, World world, int x, int y, int z) {
        float spawnX = (float)x + world.field_73012_v.nextFloat();
        float spawnY = (float)y + world.field_73012_v.nextFloat();
        float spawnZ = (float)z + world.field_73012_v.nextFloat();
        EntityItem droppedItem = new EntityItem(world, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
        droppedItem.field_70159_w = (-0.5f + world.field_73012_v.nextFloat()) * 0.05f;
        droppedItem.field_70181_x = (4.0f + world.field_73012_v.nextFloat()) * 0.05f;
        droppedItem.field_70179_y = (-0.5f + world.field_73012_v.nextFloat()) * 0.05f;
        world.func_72838_d((Entity)droppedItem);
    }

    public static int addStack(IInventory inventory, ItemStack stack, int slot, boolean simulate) {
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        if (stackInSlot == null) {
            if (!simulate) {
                inventory.func_70299_a(slot, stack.func_77946_l());
            }
            return 0;
        }
        if (stackInSlot.func_77969_a(stack)) {
            if (stackInSlot.func_77976_d() - stackInSlot.field_77994_a >= stack.field_77994_a) {
                if (!simulate) {
                    stackInSlot.field_77994_a += stack.field_77994_a;
                }
                return 0;
            }
            int insert = stackInSlot.func_77976_d() - stackInSlot.field_77994_a;
            if (!simulate) {
                stackInSlot.field_77994_a += insert;
                stack.field_77994_a -= insert;
            }
            return stack.field_77994_a - insert;
        }
        return stack.field_77994_a;
    }

    public static int addStackToInventory(IInventory inventory, ForgeDirection side, ItemStack stack) {
        stack = stack.func_77946_l();
        if (inventory instanceof ISidedInventory) {
            int[] slots;
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            for (int slot : slots = sidedInventory.func_94128_d(side.ordinal())) {
                if (!sidedInventory.func_102007_a(slot, stack, side.ordinal())) continue;
                stack.field_77994_a = TileUtils.addStack(inventory, stack, slot, false);
                if (stack.field_77994_a > 0) {
                    continue;
                }
                break;
            }
        } else {
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                if (!inventory.func_94041_b(slot, stack)) continue;
                stack.field_77994_a = TileUtils.addStack(inventory, stack, slot, false);
                if (stack.field_77994_a > 0) {
                    continue;
                }
                break;
            }
        }
        return stack.field_77994_a;
    }
}

