/*
 * Decompiled with CFR 0.152.
 */
package neresources.registry;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import neresources.api.messages.ModifyMobMessage;
import neresources.api.messages.RemoveMobMessage;
import neresources.api.utils.DropItem;
import neresources.entries.MobEntry;
import neresources.utils.ClassScraper;
import neresources.utils.MobHelper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.item.ItemStack;

public class MobRegistry {
    private Set<MobEntry> registry = new LinkedHashSet<MobEntry>();
    private static MobRegistry instance = null;

    public static MobRegistry getInstance() {
        if (instance == null) {
            instance = new MobRegistry();
            return instance;
        }
        return instance;
    }

    public boolean registerMob(MobEntry entry) {
        return this.registerMob(entry.getMobName(), entry);
    }

    public boolean registerMob(String key, MobEntry entry) {
        if (!this.registry.contains(entry)) {
            this.registry.add(entry);
            return true;
        }
        return false;
    }

    public MobEntry getMobEntry(String key) {
        return null;
    }

    public List<MobEntry> getMobsThatDropItem(ItemStack item) {
        ArrayList<MobEntry> list = new ArrayList<MobEntry>();
        for (MobEntry entry : this.registry) {
            if (!MobHelper.dropsItem(entry, item)) continue;
            list.add(entry);
        }
        return list;
    }

    public List<MobEntry> getMobs() {
        return new ArrayList<MobEntry>(this.registry);
    }

    public void removeMobDrops(ModifyMobMessage entry) {
        for (MobEntry regEntry : this.getRegistryMatches(entry.getFilterClass(), entry.isStrict(), entry.isWither())) {
            for (ItemStack item : entry.getRemoveDrops()) {
                regEntry.removeDrop(item);
            }
        }
    }

    public void addMobDrops(ModifyMobMessage entry) {
        for (MobEntry regEntry : this.getRegistryMatches(entry.getFilterClass(), entry.isStrict(), entry.isWither())) {
            for (DropItem item : entry.getAddDrops()) {
                regEntry.addDrop(item);
            }
        }
    }

    public void removeMob(RemoveMobMessage message) {
        this.registry.removeAll(this.getRegistryMatches(message.getFilterClass(), message.isStrict(), message.isWither()));
    }

    public Set<MobEntry> getRegistryMatches(Class clazz, boolean exactMatch, boolean witherSkeleton) {
        LinkedHashSet<MobEntry> result = new LinkedHashSet<MobEntry>();
        int wither = witherSkeleton ? 1 : 0;
        block0: for (MobEntry regEntry : this.registry) {
            Set<Object> classes = new LinkedHashSet();
            if (exactMatch) {
                classes.add(regEntry.getEntity().getClass());
            } else {
                classes = ClassScraper.getGeneralizations(regEntry.getEntity().getClass());
            }
            for (Object generalClass : classes) {
                if (generalClass != clazz) continue;
                if (exactMatch && clazz == EntitySkeleton.class && ((EntitySkeleton)regEntry.getEntity()).func_82202_m() != wither) continue block0;
                result.add(regEntry);
            }
        }
        return result;
    }

    public void clear() {
        instance = new MobRegistry();
    }
}

