/*
 * Decompiled with CFR 0.152.
 */
package neresources.registry;

import java.util.LinkedHashSet;
import java.util.Set;
import neresources.api.messages.Message;
import neresources.api.messages.ModifyMessage;
import neresources.api.messages.ModifyMobMessage;
import neresources.api.messages.ModifyOreMessage;
import neresources.api.messages.ModifyPlantMessage;
import neresources.api.messages.RegisterDungeonMessage;
import neresources.api.messages.RegisterMobMessage;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.messages.RegistryMessage;
import neresources.api.messages.RemoveMobMessage;
import neresources.api.utils.Priority;
import neresources.entries.DungeonEntry;
import neresources.entries.MobEntry;
import neresources.registry.DungeonRegistry;
import neresources.registry.MobRegistry;
import neresources.registry.OreRegistry;
import net.minecraft.nbt.NBTTagCompound;

public class MessageRegistry {
    private static Set<Message> registerMessages = new LinkedHashSet<Message>();
    private static Set<ModifyMessage> modifyMessages = new LinkedHashSet<ModifyMessage>();
    private static Set<RegistryMessage> registryMessages = new LinkedHashSet<RegistryMessage>();

    public static void clear() {
        registerMessages = new LinkedHashSet<Message>();
        modifyMessages = new LinkedHashSet<ModifyMessage>();
        registryMessages = new LinkedHashSet<RegistryMessage>();
    }

    private static void getModifyMessages(Priority priority, Set<ModifyMessage> add, Set<ModifyMessage> remove) {
        for (ModifyMessage message : modifyMessages) {
            if (message.hasAdd() && message.getAddPriority() == priority) {
                add.add(message);
            }
            if (!message.hasRemove() || message.getRemovePriority() != priority) continue;
            remove.add(message);
        }
    }

    private static void getRegistryMessages(Priority priority, Set<RegistryMessage> add, Set<RegistryMessage> remove) {
        for (RegistryMessage message : registryMessages) {
            if (message.getAddPriority() == priority) {
                add.add(message);
            }
            if (message.getRemovePriority() != priority) continue;
            remove.add(message);
        }
    }

    public static void addMessage(Message message) {
        if (message == null || !message.isValid()) {
            return;
        }
        if (message instanceof ModifyMessage) {
            modifyMessages.add((ModifyMessage)message);
        } else if (message instanceof RegistryMessage) {
            registryMessages.add((RegistryMessage)message);
        }
    }

    public static void registerMessage(String key, NBTTagCompound tagCompound) {
        Message message = null;
        if (key.equals("registerMob")) {
            message = new RegisterMobMessage(tagCompound);
        } else if (key.equals("registerOre")) {
            message = new RegisterOreMessage(tagCompound);
        } else if (key.equals("registerDungeon")) {
            message = new RegisterDungeonMessage(tagCompound);
        } else if (key.equals("modifyMob")) {
            message = new ModifyMobMessage(tagCompound);
        } else if (key.equals("modifyOre")) {
            message = new ModifyOreMessage(tagCompound);
        } else if (key.equals("modifyPlant")) {
            message = new ModifyPlantMessage(tagCompound);
        } else if (key.equals("removeMob")) {
            message = new RemoveMobMessage(tagCompound);
        }
        MessageRegistry.addMessage(message);
    }

    public static void processMessages() {
        LinkedHashSet<RegistryMessage> removeMessages;
        LinkedHashSet<RegistryMessage> addMessages;
        for (Priority priority : Priority.values()) {
            addMessages = new LinkedHashSet<RegistryMessage>();
            removeMessages = new LinkedHashSet<RegistryMessage>();
            MessageRegistry.getRegistryMessages(priority, addMessages, removeMessages);
            for (RegistryMessage registryMessage : addMessages) {
                if (registryMessage instanceof RegisterOreMessage) {
                    OreRegistry.registerOre((RegisterOreMessage)registryMessage);
                    continue;
                }
                if (registryMessage instanceof RegisterMobMessage) {
                    MobRegistry.getInstance().registerMob(new MobEntry((RegisterMobMessage)registryMessage));
                    continue;
                }
                if (!(registryMessage instanceof RegisterDungeonMessage)) continue;
                DungeonRegistry.getInstance().registerDungeonEntry(new DungeonEntry((RegisterDungeonMessage)registryMessage));
            }
            for (RegistryMessage registryMessage : removeMessages) {
                if (!(registryMessage instanceof RemoveMobMessage)) continue;
                MobRegistry.getInstance().removeMob((RemoveMobMessage)registryMessage);
            }
        }
        for (Priority priority : Priority.values()) {
            addMessages = new LinkedHashSet();
            removeMessages = new LinkedHashSet();
            MessageRegistry.getModifyMessages(priority, addMessages, removeMessages);
            for (ModifyMessage modifyMessage : addMessages) {
                if (modifyMessage instanceof ModifyMobMessage) {
                    MobRegistry.getInstance().addMobDrops((ModifyMobMessage)modifyMessage);
                    continue;
                }
                if (!(modifyMessage instanceof ModifyOreMessage)) continue;
                OreRegistry.addDrops((ModifyOreMessage)modifyMessage);
            }
            for (ModifyMessage modifyMessage : removeMessages) {
                if (modifyMessage instanceof ModifyMobMessage) {
                    MobRegistry.getInstance().removeMobDrops((ModifyMobMessage)modifyMessage);
                    continue;
                }
                if (!(modifyMessage instanceof ModifyOreMessage)) continue;
                OreRegistry.removeDrops((ModifyOreMessage)modifyMessage);
            }
        }
    }
}

