/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.meta;

import cofh.lib.util.helpers.FireworksHelper;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.item.meta.Jetpack;
import tonius.simplyjetpacks.setup.ModKey;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;

public class JetpackPotato
extends Jetpack {
    protected static final String TAG_FIRED = "JetpackPotatoFired";
    protected static final String TAG_ROCKET_TIMER = "JetpackPotatoRocketTimer";
    protected static final String TAG_ROCKET_TIMER_SET = "JetpackPotatoRocketTimerSet";

    public JetpackPotato(int tier, EnumRarity rarity, String defaultConfigKey) {
        super(tier, rarity, defaultConfigKey);
        this.setHasStateIndicators(false);
        this.setShowEmptyInCreativeTab(false);
        this.setArmorModel(PackModelType.FLAT);
    }

    @Override
    public void flyUser(EntityLivingBase user, ItemStack stack, ItemPack item, boolean force) {
        if (this.isFired(stack)) {
            super.flyUser(user, stack, item, true);
            user.field_70759_as += 37.5f;
            if (item.getFuelStored(stack) <= 0) {
                user.func_70062_b(3, null);
                if (!user.field_70170_p.field_72995_K) {
                    user.field_70170_p.func_72876_a((Entity)user, user.field_70165_t, user.field_70163_u, user.field_70161_v, 4.0f, false);
                    for (int i = 0; i <= MathHelper.RANDOM.nextInt(3) + 4; ++i) {
                        ItemStack firework = FireworksHelper.getRandomFireworks((int)0, (int)1, (int)(MathHelper.RANDOM.nextInt(6) + 1), (int)1);
                        user.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(user.field_70170_p, user.field_70165_t + MathHelper.RANDOM.nextDouble() * 6.0 - 3.0, user.field_70163_u, user.field_70161_v + MathHelper.RANDOM.nextDouble() * 6.0 - 3.0, firework));
                    }
                    user.func_70097_a((DamageSource)new EntityDamageSource("jetpackpotato", (Entity)user), 100.0f);
                    if (user instanceof EntityPlayer) {
                        user.func_145779_a(Items.field_151168_bH, 1);
                    }
                }
            }
        } else if (force || SyncHandler.isFlyKeyDown(user)) {
            if (this.isTimerSet(stack)) {
                this.decrementTimer(stack, user);
            } else {
                this.setTimer(stack, 50);
            }
        }
    }

    @Override
    public boolean isOn(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isHoverModeOn(ItemStack stack) {
        return false;
    }

    @Override
    public void togglePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    @Override
    public void switchModePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    @Override
    public ModKey[] getGuiControls() {
        return new ModKey[0];
    }

    @Override
    public ParticleType getDisplayParticleType(ItemStack itemStack, ItemPack item, EntityLivingBase user) {
        if (!this.isFired(itemStack) && SyncHandler.isFlyKeyDown(user)) {
            return user.func_70681_au().nextInt(5) == 0 ? ParticleType.SMOKE : null;
        }
        if (this.isFired(itemStack)) {
            return this.getParticleType(itemStack);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftInformation(ItemStack stack, ItemPack item, EntityPlayer player, List list) {
        super.addShiftInformation(stack, item, player, list);
        list.add("\u00a7c\u00a7o" + SJStringHelper.localize("tooltip.jetpackPotato.warning", new Object[0]));
    }

    protected boolean isFired(ItemStack itemStack) {
        return NBTHelper.getNBT(itemStack).func_74767_n(TAG_FIRED);
    }

    protected void setFired(ItemStack itemStack) {
        NBTHelper.getNBT(itemStack).func_74757_a(TAG_FIRED, true);
    }

    protected void setTimer(ItemStack itemStack, int timer) {
        NBTHelper.getNBT(itemStack).func_74768_a(TAG_ROCKET_TIMER, timer);
        NBTHelper.getNBT(itemStack).func_74757_a(TAG_ROCKET_TIMER_SET, true);
    }

    protected boolean isTimerSet(ItemStack itemStack) {
        return NBTHelper.getNBT(itemStack).func_74767_n(TAG_ROCKET_TIMER_SET);
    }

    protected void decrementTimer(ItemStack itemStack, EntityLivingBase user) {
        int timer = NBTHelper.getNBT(itemStack).func_74762_e(TAG_ROCKET_TIMER);
        timer = timer > 0 ? timer - 1 : 0;
        NBTHelper.getNBT(itemStack).func_74768_a(TAG_ROCKET_TIMER, timer);
        if (timer == 0) {
            this.setFired(itemStack);
            user.field_70170_p.func_72956_a((Entity)user, "simplyjetpacks:rocket", 1.0f, 1.0f);
        }
    }
}

