/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.module.tabula.client.formats;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import us.ichun.module.tabula.client.formats.types.ImportTabula;
import us.ichun.module.tabula.client.formats.types.Importer;
import us.ichun.module.tabula.common.project.ProjectInfo;

public class ImportList {
    public static final ImportTabula tabulaImporterInstance = new ImportTabula();
    public static final HashMap<String, Importer> compatibleFormats = new HashMap<String, Importer>(){
        {
            this.put("tcn", tabulaImporterInstance);
            this.put("tc2", tabulaImporterInstance);
            this.put("tbl", tabulaImporterInstance);
        }
    };

    public static boolean isFileSupported(File file) {
        return compatibleFormats.containsKey(FilenameUtils.getExtension((String)file.getName()));
    }

    public static ProjectInfo createProjectFromFile(File file) {
        if (compatibleFormats.containsKey(FilenameUtils.getExtension((String)file.getName()))) {
            return compatibleFormats.get(FilenameUtils.getExtension((String)file.getName())).createProjectInfo(file);
        }
        return null;
    }
}

