/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.solids;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.block.AEBaseBlock;
import appeng.client.render.blocks.RenderQuartzOre;
import appeng.core.features.AEFeature;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OreQuartz
extends AEBaseBlock {
    private int boostBrightnessLow;
    private int boostBrightnessHigh;
    private boolean enhanceBrightness;

    public OreQuartz() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.boostBrightnessLow = 0;
        this.boostBrightnessHigh = 1;
        this.enhanceBrightness = false;
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderQuartzOre getRenderer() {
        return new RenderQuartzOre();
    }

    public int func_149677_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4) {
        int j1 = super.func_149677_c(par1iBlockAccess, par2, par3, par4);
        if (this.enhanceBrightness) {
            j1 = (j1 = Math.max(j1 >> 20, j1 >> 4)) > 4 ? (j1 += this.boostBrightnessHigh) : (j1 += this.boostBrightnessLow);
            if (j1 > 15) {
                j1 = 15;
            }
            return j1 << 20 | j1 << 4;
        }
        return j1;
    }

    public int func_149745_a(Random rand) {
        return 1 + rand.nextInt(2);
    }

    @Nullable
    public Item func_149650_a(int id, Random rand, int meta) {
        Iterator i$ = AEApi.instance().definitions().materials().certusQuartzCrystal().maybeItem().asSet().iterator();
        if (i$.hasNext()) {
            Item crystalItem = (Item)i$.next();
            return crystalItem;
        }
        throw new MissingDefinition("Tried to access certus quartz crystal, even though they are disabled");
    }

    public void func_149690_a(World w, int x, int y, int z, int blockID, float something, int meta) {
        super.func_149690_a(w, x, y, z, blockID, something, meta);
        if (this.func_149650_a(blockID, w.field_73012_v, meta) != Item.func_150898_a((Block)this)) {
            int xp = MathHelper.func_76136_a((Random)w.field_73012_v, (int)2, (int)5);
            this.func_149657_c(w, x, y, z, xp);
        }
    }

    public int func_149692_a(int id) {
        Iterator i$ = AEApi.instance().definitions().materials().certusQuartzCrystal().maybeStack(1).asSet().iterator();
        if (i$.hasNext()) {
            ItemStack crystalStack = (ItemStack)i$.next();
            return crystalStack.func_77960_j();
        }
        throw new MissingDefinition("Tried to access certus quartz crystal, even though they are disabled");
    }

    public int func_149679_a(int fortune, Random rand) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_149650_a(0, rand, fortune)) {
            int j = rand.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(rand) * (j + 1);
        }
        return this.func_149745_a(rand);
    }

    void setBoostBrightnessLow(int boostBrightnessLow) {
        this.boostBrightnessLow = boostBrightnessLow;
    }

    void setBoostBrightnessHigh(int boostBrightnessHigh) {
        this.boostBrightnessHigh = boostBrightnessHigh;
    }

    public void setEnhanceBrightness(boolean enhanceBrightness) {
        this.enhanceBrightness = enhanceBrightness;
    }
}

