/*
 * Decompiled with CFR 0.152.
 */
package com.nicklanam.forge.springboards;

import com.nicklanam.forge.springboards.SpringBoardsTab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SpringBlock
extends Block {
    public static final String STRENGTH_LOW = "weak";
    public static final String STRENGTH_MID = "medium";
    public static final String STRENGTH_HIGH = "strong";
    public static final Map<String, Double> springStrengths = new HashMap<String, Double>();
    public static final Map<String, Integer> springProtection = new HashMap<String, Integer>();
    private IIcon[] icons = new IIcon[6];
    private String strength;

    public SpringBlock(String strength) throws IllegalArgumentException {
        super(Material.field_151573_f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(SpringBoardsTab.getInstance());
        if (!Arrays.asList(STRENGTH_LOW, STRENGTH_MID, STRENGTH_HIGH).contains(strength)) {
            throw new IllegalArgumentException("Use one of the defined spring strengths");
        }
        this.strength = strength;
        this.func_149663_c(strength + "SpringBlock");
        this.func_149658_d("springboards:" + strength + "SpringBlock");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        String textureName = "springboards:" + this.strength + "SpringBlock";
        this.icons[0] = registry.func_94245_a(textureName + "_bottom");
        this.icons[1] = registry.func_94245_a(textureName + "_top");
        this.icons[2] = registry.func_94245_a(textureName + "_side");
        this.icons[3] = registry.func_94245_a(textureName + "_side");
        this.icons[4] = registry.func_94245_a(textureName + "_side");
        this.icons[5] = registry.func_94245_a(textureName + "_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[side];
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float r1, float r2, float r3) {
        if (player.func_70694_bm() == null && world.field_72995_K) {
            double dx = Math.abs(player.field_70165_t - (double)x - 0.5);
            double dy = Math.ceil(player.field_70163_u - (double)player.field_70129_M) - (double)y;
            double dz = Math.abs(player.field_70161_v - (double)z - 0.5);
            if (dy == 1.0 && dx <= 0.5 && dz <= 0.5) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("springboards.msg.boing", new Object[0]));
                player.field_70181_x = springStrengths.get(this.strength);
                player.field_70133_I = true;
            }
        }
        return false;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float whatIsThis) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.field_70143_R = player.field_70181_x > -1.0 * springStrengths.get(this.strength) ? 0.0f : (player.field_70143_R -= (float)springProtection.get(this.strength).intValue());
        }
    }

    static {
        springStrengths.put(STRENGTH_LOW, 1.21);
        springStrengths.put(STRENGTH_MID, 1.77);
        springStrengths.put(STRENGTH_HIGH, 2.67);
        springProtection.put(STRENGTH_LOW, 8);
        springProtection.put(STRENGTH_MID, 16);
        springProtection.put(STRENGTH_HIGH, 32);
    }
}

