/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import openmods.reflection.TypeUtils;
import openperipheral.adapter.AnnotationMetaExtractor;
import openperipheral.adapter.IMethodDescription;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.property.GetterExecutor;
import openperipheral.adapter.property.IFieldManipulator;
import openperipheral.adapter.property.IIndexedFieldManipulator;
import openperipheral.adapter.property.IIndexedPropertyAccessHandler;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.ISinglePropertyAccessHandler;
import openperipheral.adapter.property.IndexedGetterExecutor;
import openperipheral.adapter.property.IndexedManipulatorProvider;
import openperipheral.adapter.property.IndexedSetterExecutor;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.property.IndexedTypeInfoBuilder;
import openperipheral.adapter.property.MergedGetterExecutor;
import openperipheral.adapter.property.MergedSetterExecutor;
import openperipheral.adapter.property.PropertyDescriptionBuilder;
import openperipheral.adapter.property.PropertyExecutor;
import openperipheral.adapter.property.SetterExecutor;
import openperipheral.adapter.property.SingleManipulatorProvider;
import openperipheral.adapter.property.SingleTypeInfo;
import openperipheral.adapter.property.SingleTypeInfoBuilder;
import openperipheral.adapter.types.TypeHelper;
import openperipheral.api.adapter.CallbackProperty;
import openperipheral.api.adapter.IIndexedPropertyCallback;
import openperipheral.api.adapter.IPropertyCallback;
import openperipheral.api.adapter.IndexedCallbackProperty;
import openperipheral.api.adapter.IndexedProperty;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.property.GetTypeFromField;
import openperipheral.api.property.IIndexedPropertyListener;
import openperipheral.api.property.ISinglePropertyListener;

public class PropertyListBuilder {
    private final Class<?> ownerClass;
    private final Field field;
    private final String source;
    private SingleParameters singleParameters;
    private IndexedParameters indexedParameters;
    private final ISinglePropertyAccessHandler singleAccessHandler;
    private final IIndexedPropertyAccessHandler indexedAccessHandler;
    private final Set<String> excludedArchitectures = Sets.newHashSet();
    private final Set<String> featureGroups = Sets.newHashSet();

    public PropertyListBuilder(Class<?> ownerClass, Field field, String source) {
        Preconditions.checkArgument((boolean)field.getDeclaringClass().isAssignableFrom(ownerClass), (String)"Field %s not usable on %s", (Object[])new Object[]{field, ownerClass});
        this.ownerClass = ownerClass;
        this.field = field;
        this.source = source;
        this.singleAccessHandler = PropertyListBuilder.getSingleAccessHandler(ownerClass);
        this.indexedAccessHandler = PropertyListBuilder.getIndexedAccessHandler(ownerClass);
    }

    private static ISinglePropertyAccessHandler getSingleAccessHandler(Class<?> ownerClass) {
        return ISinglePropertyListener.class.isAssignableFrom(ownerClass) ? ISinglePropertyAccessHandler.DELEGATE_TO_OWNER : ISinglePropertyAccessHandler.IGNORE;
    }

    private static IIndexedPropertyAccessHandler getIndexedAccessHandler(Class<?> ownerClass) {
        return IIndexedPropertyListener.class.isAssignableFrom(ownerClass) ? IIndexedPropertyAccessHandler.DELEGATE_TO_OWNER : IIndexedPropertyAccessHandler.IGNORE;
    }

    public void addSingle(String name, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly, boolean valueNullable, Class<?> valueType, ArgType docType) {
        this.singleParameters = new SingleParameters(name, getterDescription, setterDescription, isDelegating, readOnly, valueNullable, valueType, docType);
    }

    public void addProperty(Property property) {
        this.addSingle(property.name(), property.getterDesc(), property.setterDesc(), false, property.readOnly(), property.nullable(), GetTypeFromField.class, property.type());
    }

    public void addProperty(CallbackProperty property) {
        this.addSingle(property.name(), property.getterDesc(), property.setterDesc(), true, property.readOnly(), property.nullable(), property.javaType(), property.type());
    }

    public void addIndexed(String name, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly, boolean valueNullable, boolean expandable, Class<?> keyType, ArgType keyDocType, Class<?> valueType, ArgType valueDocType) {
        this.indexedParameters = new IndexedParameters(name, getterDescription, setterDescription, isDelegating, readOnly, valueNullable, expandable, keyType, keyDocType, valueType, valueDocType);
    }

    public void addProperty(IndexedProperty property) {
        this.addIndexed(property.name(), property.getterDesc(), property.setterDesc(), false, property.readOnly(), property.nullable(), property.expandable(), GetTypeFromField.class, property.keyType(), GetTypeFromField.class, ArgType.AUTO);
    }

    public void addProperty(IndexedCallbackProperty property) {
        this.addIndexed(property.name(), property.getterDesc(), property.setterDesc(), true, property.readOnly(), property.nullable(), false, property.keyType(), property.keyDocType(), property.valueType(), property.valueDocType());
    }

    public PropertyListBuilder configureFromFieldProperties() {
        Property singleProperty = this.field.getAnnotation(Property.class);
        CallbackProperty singleCallbackProperty = this.field.getAnnotation(CallbackProperty.class);
        if (singleProperty != null) {
            this.addProperty(singleProperty);
        } else if (singleCallbackProperty != null) {
            this.addProperty(singleCallbackProperty);
        }
        IndexedProperty indexedProperty = this.field.getAnnotation(IndexedProperty.class);
        IndexedCallbackProperty indexedCallbackProperty = this.field.getAnnotation(IndexedCallbackProperty.class);
        if (indexedProperty != null) {
            this.addProperty(indexedProperty);
        } else if (indexedCallbackProperty != null) {
            this.addProperty(indexedCallbackProperty);
        }
        return this;
    }

    public PropertyListBuilder configureFromFieldMeta(AnnotationMetaExtractor metaInfo) {
        this.excludedArchitectures.addAll(metaInfo.getExcludedArchitectures(this.field));
        this.featureGroups.addAll(metaInfo.getFeatureGroups(this.field));
        return this;
    }

    public void addMethods(List<IMethodExecutor> output) {
        this.field.setAccessible(true);
        if (this.singleParameters != null && this.indexedParameters == null) {
            this.addSinglePropertyMethods(output, this.singleParameters);
        } else if (this.singleParameters == null && this.indexedParameters != null) {
            this.addIndexedPropertyMethods(output, this.indexedParameters);
        } else if (this.singleParameters != null && this.indexedParameters != null) {
            if (this.singleParameters.name.equals(this.indexedParameters.name)) {
                this.addMergedPropertyMethods(output, this.singleParameters, this.indexedParameters);
            } else {
                this.addSinglePropertyMethods(output, this.singleParameters);
                this.addIndexedPropertyMethods(output, this.indexedParameters);
            }
        }
    }

    private void addSinglePropertyMethods(List<IMethodExecutor> output, SingleParameters params) {
        this.precheckSingleField(params);
        IFieldManipulator fieldManipulator = SingleManipulatorProvider.getProvider(this.field.getType(), params.isDelegating);
        output.add(this.createSinglePropertyGetter(params, fieldManipulator));
        if (!params.readOnly) {
            output.add(this.createSinglePropertySetter(params, fieldManipulator));
        }
    }

    private void addIndexedPropertyMethods(List<IMethodExecutor> output, IndexedParameters params) {
        this.precheckIndexedField(params);
        IIndexedFieldManipulator fieldManipulator = IndexedManipulatorProvider.getProvider(this.field.getType(), params.isDelegating, params.expandable);
        output.add(this.createIndexedPropertyGetter(params, fieldManipulator));
        if (!params.readOnly) {
            output.add(this.createIndexedPropertySetter(params, fieldManipulator));
        }
    }

    private void addMergedPropertyMethods(List<IMethodExecutor> output, SingleParameters singleParameters, IndexedParameters indexedParameters) {
        this.precheckSingleField(singleParameters);
        this.precheckIndexedField(indexedParameters);
        Class<?> fieldType = this.field.getType();
        IFieldManipulator singleFieldManipulator = SingleManipulatorProvider.getProvider(fieldType, singleParameters.isDelegating);
        IIndexedFieldManipulator indexedFieldManipulator = IndexedManipulatorProvider.getProvider(fieldType, indexedParameters.isDelegating, indexedParameters.expandable);
        output.add(this.createMergedPropertyGetter(singleParameters, singleFieldManipulator, indexedParameters, indexedFieldManipulator));
        if (!singleParameters.readOnly && !indexedParameters.readOnly) {
            output.add(this.createMergedPropertySetter(singleParameters, singleFieldManipulator, indexedParameters, indexedFieldManipulator));
        } else if (!indexedParameters.readOnly) {
            output.add(this.createIndexedPropertySetter(indexedParameters, indexedFieldManipulator));
        } else if (!singleParameters.readOnly) {
            output.add(this.createSinglePropertySetter(singleParameters, singleFieldManipulator));
        }
    }

    private PropertyExecutor createPropertyExecutor(IMethodDescription description, IPropertyExecutor caller) {
        return new PropertyExecutor(description, caller, this.excludedArchitectures, this.featureGroups);
    }

    private IMethodExecutor createSinglePropertyGetter(SingleParameters params, IFieldManipulator fieldManipulator) {
        PropertyDescriptionBuilder descriptionBuilder = new PropertyDescriptionBuilder(params.name, this.source);
        descriptionBuilder.addSingleParameter(params.typeInfo);
        if (!Strings.isNullOrEmpty((String)params.getterDescription)) {
            descriptionBuilder.overrideDescription(params.getterDescription);
        }
        IMethodDescription description = descriptionBuilder.buildGetter();
        GetterExecutor caller = new GetterExecutor(this.field, fieldManipulator, this.singleAccessHandler);
        return this.createPropertyExecutor(description, caller);
    }

    private IMethodExecutor createSinglePropertySetter(SingleParameters params, IFieldManipulator fieldManipulator) {
        PropertyDescriptionBuilder descriptionBuilder = new PropertyDescriptionBuilder(params.name, this.source);
        descriptionBuilder.addSingleParameter(params.typeInfo);
        if (!Strings.isNullOrEmpty((String)params.setterDescription)) {
            descriptionBuilder.overrideDescription(params.setterDescription);
        }
        IMethodDescription description = descriptionBuilder.buildSetter();
        SetterExecutor caller = new SetterExecutor(this.field, fieldManipulator, params.typeInfo, this.singleAccessHandler, params.valueNullable);
        return this.createPropertyExecutor(description, caller);
    }

    private IMethodExecutor createIndexedPropertyGetter(IndexedParameters params, IIndexedFieldManipulator fieldManipulator) {
        PropertyDescriptionBuilder descriptionBuilder = new PropertyDescriptionBuilder(params.name, this.source);
        descriptionBuilder.addIndexParameter(params.typeInfo);
        if (!Strings.isNullOrEmpty((String)params.getterDescription)) {
            descriptionBuilder.overrideDescription(params.getterDescription);
        }
        IMethodDescription description = descriptionBuilder.buildGetter();
        IndexedGetterExecutor caller = new IndexedGetterExecutor(this.field, fieldManipulator, params.typeInfo, this.indexedAccessHandler);
        return this.createPropertyExecutor(description, caller);
    }

    private IMethodExecutor createIndexedPropertySetter(IndexedParameters params, IIndexedFieldManipulator fieldManipulator) {
        PropertyDescriptionBuilder descriptionBuilder = new PropertyDescriptionBuilder(params.name, this.source);
        descriptionBuilder.addIndexParameter(params.typeInfo);
        if (!Strings.isNullOrEmpty((String)params.setterDescription)) {
            descriptionBuilder.overrideDescription(params.setterDescription);
        }
        IMethodDescription description = descriptionBuilder.buildSetter();
        IndexedSetterExecutor caller = new IndexedSetterExecutor(this.field, fieldManipulator, params.typeInfo, this.indexedAccessHandler, params.valueNullable);
        return this.createPropertyExecutor(description, caller);
    }

    private IMethodExecutor createMergedPropertyGetter(SingleParameters singleParameters, IFieldManipulator singleFieldManipulator, IndexedParameters indexedParameters, IIndexedFieldManipulator indexedFieldManipulator) {
        PropertyDescriptionBuilder descriptionBuilder = new PropertyDescriptionBuilder(singleParameters.name, this.source);
        descriptionBuilder.addSingleParameter(singleParameters.typeInfo);
        descriptionBuilder.addIndexParameter(indexedParameters.typeInfo);
        if (!Strings.isNullOrEmpty((String)singleParameters.getterDescription)) {
            descriptionBuilder.overrideDescription(singleParameters.getterDescription);
        } else if (!Strings.isNullOrEmpty((String)indexedParameters.getterDescription)) {
            descriptionBuilder.overrideDescription(indexedParameters.getterDescription);
        }
        IMethodDescription description = descriptionBuilder.buildGetter();
        MergedGetterExecutor caller = new MergedGetterExecutor(this.field, singleFieldManipulator, this.singleAccessHandler, indexedFieldManipulator, indexedParameters.typeInfo, this.indexedAccessHandler);
        return this.createPropertyExecutor(description, caller);
    }

    private IMethodExecutor createMergedPropertySetter(SingleParameters singleParameters, IFieldManipulator singleFieldManipulator, IndexedParameters indexedParameters, IIndexedFieldManipulator indexedFieldManipulator) {
        PropertyDescriptionBuilder descriptionBuilder = new PropertyDescriptionBuilder(singleParameters.name, this.source);
        descriptionBuilder.addSingleParameter(singleParameters.typeInfo);
        descriptionBuilder.addIndexParameter(indexedParameters.typeInfo);
        if (!Strings.isNullOrEmpty((String)singleParameters.setterDescription)) {
            descriptionBuilder.overrideDescription(singleParameters.setterDescription);
        } else if (!Strings.isNullOrEmpty((String)singleParameters.setterDescription)) {
            descriptionBuilder.overrideDescription(singleParameters.setterDescription);
        }
        IMethodDescription description = descriptionBuilder.buildSetter();
        MergedSetterExecutor caller = new MergedSetterExecutor(this.field, singleParameters.valueNullable, singleFieldManipulator, singleParameters.typeInfo, this.singleAccessHandler, indexedParameters.valueNullable, indexedFieldManipulator, indexedParameters.typeInfo, this.indexedAccessHandler);
        return this.createPropertyExecutor(description, caller);
    }

    private void precheckSingleField(SingleParameters params) {
        int modifiers = this.field.getModifiers();
        boolean isFinal = Modifier.isFinal(modifiers);
        Class<?> fieldType = this.field.getType();
        Preconditions.checkArgument((!Modifier.isStatic(modifiers) ? 1 : 0) != 0, (Object)"Field marked with @Property can't be static");
        Preconditions.checkArgument((params.readOnly || !isFinal ? 1 : 0) != 0, (Object)"Only fields marked with @Property(readOnly = true) can be marked final");
        Preconditions.checkArgument((!params.valueNullable || !fieldType.isPrimitive() ? 1 : 0) != 0, (Object)"Fields with primitive types can't be nullable");
        Preconditions.checkArgument((!params.isDelegating || IPropertyCallback.class.isAssignableFrom(this.ownerClass) ? 1 : 0) != 0, (Object)"Only classes implementing IPropertyCallback can use @CallbackProperty");
    }

    private void precheckIndexedField(IndexedParameters params) {
        int modifiers = this.field.getModifiers();
        boolean isFinal = Modifier.isFinal(modifiers);
        Preconditions.checkArgument((!Modifier.isStatic(modifiers) ? 1 : 0) != 0, (Object)"Field marked with @IndexedProperty can't be static");
        Preconditions.checkArgument((!params.expandable || !params.readOnly ? 1 : 0) != 0, (Object)"@IndexedProperty fields can't be both read-only and expandable");
        Preconditions.checkArgument((!params.expandable || !isFinal ? 1 : 0) != 0, (Object)"Only non-final @IndexedProperty fields can me expandable");
        Preconditions.checkArgument((!params.isDelegating || IIndexedPropertyCallback.class.isAssignableFrom(this.ownerClass) ? 1 : 0) != 0, (Object)"Only classes implementing IIndexedPropertyCallback can use @CallbackIndexedProperty");
    }

    public static void buildPropertyList(Class<?> rootClass, Class<?> targetCls, String source, AnnotationMetaExtractor metaInfo, List<IMethodExecutor> output) {
        for (Field f : targetCls.getDeclaredFields()) {
            new PropertyListBuilder(rootClass, f, source).configureFromFieldMeta(metaInfo).configureFromFieldProperties().addMethods(output);
        }
    }

    private class IndexedParameters
    extends Parameters {
        public final boolean expandable;
        public final IndexedTypeInfo typeInfo;

        public IndexedParameters(String name, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly, boolean valueNullable, boolean expandable, Class<?> keyType, ArgType keyDocType, Class<?> valueType, ArgType valueDocType) {
            super(name, getterDescription, setterDescription, isDelegating, readOnly, valueNullable);
            this.expandable = expandable;
            TypeToken fieldType = TypeUtils.resolveFieldType((Class)PropertyListBuilder.this.ownerClass, (Field)PropertyListBuilder.this.field);
            IndexedTypeInfoBuilder typeInfoBuilder = new IndexedTypeInfoBuilder(fieldType.getType());
            if (keyType != GetTypeFromField.class) {
                typeInfoBuilder.overrideKeyType(keyType);
            }
            if (keyDocType != ArgType.AUTO) {
                typeInfoBuilder.overrideKeyDocType(TypeHelper.single(keyDocType));
            }
            if (valueType != GetTypeFromField.class) {
                typeInfoBuilder.overrideValueType(valueType);
            }
            if (valueDocType != ArgType.AUTO) {
                typeInfoBuilder.overrideValueDocType(TypeHelper.single(valueDocType));
            }
            this.typeInfo = typeInfoBuilder.build();
        }
    }

    private class SingleParameters
    extends Parameters {
        public final SingleTypeInfo typeInfo;

        public SingleParameters(String name, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly, boolean valueNullable, Class<?> valueType, ArgType valueDocType) {
            super(name, getterDescription, setterDescription, isDelegating, readOnly, valueNullable);
            TypeToken fieldType = TypeUtils.resolveFieldType((Class)PropertyListBuilder.this.ownerClass, (Field)PropertyListBuilder.this.field);
            SingleTypeInfoBuilder typeInfoBuilder = new SingleTypeInfoBuilder(fieldType.getType());
            if (valueType != GetTypeFromField.class) {
                typeInfoBuilder.overrideValueType(valueType);
            }
            if (valueDocType != ArgType.AUTO) {
                typeInfoBuilder.overrideValueDocType(TypeHelper.single(valueDocType));
            }
            this.typeInfo = typeInfoBuilder.build();
        }
    }

    private class Parameters {
        public final String name;
        public final String getterDescription;
        public final String setterDescription;
        public final boolean isDelegating;
        public final boolean readOnly;
        public final boolean valueNullable;

        public Parameters(String name, String getterDescription, String setterDescription, boolean isDelegating, boolean readOnly, boolean valueNullable) {
            this.name = Strings.isNullOrEmpty((String)name) ? PropertyListBuilder.this.field.getName() : name;
            this.getterDescription = getterDescription;
            this.setterDescription = setterDescription;
            this.isDelegating = isDelegating;
            this.readOnly = readOnly;
            this.valueNullable = valueNullable;
        }
    }
}

