/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.Position;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotStripesHandler
extends AIRobot
implements IStripesActivator {
    private BlockIndex useToBlock;
    private int useCycles = 0;

    public AIRobotStripesHandler(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotStripesHandler(EntityRobotBase iRobot, BlockIndex index) {
        this(iRobot);
        this.useToBlock = index;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.useToBlock.x, this.useToBlock.y, this.useToBlock.z);
        this.robot.setItemActive(true);
    }

    @Override
    public void update() {
        if (this.useToBlock == null) {
            this.setSuccess(false);
            this.terminate();
            return;
        }
        ++this.useCycles;
        if (this.useCycles > 60) {
            ItemStack stack = this.robot.func_70694_bm();
            ForgeDirection direction = ForgeDirection.NORTH;
            Position p = new Position(this.useToBlock.x, this.useToBlock.y, this.useToBlock.z);
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p, (int)p.x, (int)p.y, (int)p.z).get();
            player.field_70125_A = 0.0f;
            player.field_70177_z = 180.0f;
            for (IStripesHandler handler : PipeManager.stripesHandlers) {
                if (handler.getType() != IStripesHandler.StripesHandlerType.ITEM_USE || !handler.shouldHandle(stack) || !handler.handle(this.robot.field_70170_p, (int)p.x, (int)p.y, (int)p.z, direction, stack, player, this)) continue;
                this.robot.setItemInUse(null);
                this.terminate();
                return;
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public int getEnergyCost() {
        return 15;
    }

    @Override
    public void sendItem(ItemStack stack, ForgeDirection direction) {
        InvUtils.dropItems(this.robot.field_70170_p, stack, (int)Math.floor(this.robot.field_70165_t), (int)Math.floor(this.robot.field_70163_u), (int)Math.floor(this.robot.field_70161_v));
    }

    @Override
    public void dropItem(ItemStack stack, ForgeDirection direction) {
        this.sendItem(stack, direction);
    }
}

