/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.schematics;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;

public class SchematicMinecart
extends SchematicEntity {
    private Item baseItem;

    public SchematicMinecart(Item baseItem) {
        this.baseItem = baseItem;
    }

    @Override
    public void translateToBlueprint(Translation transform) {
        super.translateToBlueprint(transform);
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos.x -= 0.5;
        pos.z -= 0.5;
        this.entityNBT.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
    }

    @Override
    public void translateToWorld(Translation transform) {
        super.translateToWorld(transform);
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position pos = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        pos.x += 0.5;
        pos.z += 0.5;
        this.entityNBT.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(pos.x, pos.y, pos.z));
    }

    @Override
    public void readFromWorld(IBuilderContext context, Entity entity) {
        super.readFromWorld(context, entity);
        this.storedRequirements = new ItemStack[1];
        this.storedRequirements[0] = new ItemStack(this.baseItem);
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        NBTTagList nbttaglist = this.entityNBT.func_150295_c("Pos", 6);
        Position newPosition = new Position(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        for (Object o : context.world().field_72996_f) {
            Entity e = (Entity)o;
            Position existingPositon = new Position(e.field_70165_t, e.field_70163_u, e.field_70161_v);
            if (!(e instanceof EntityMinecart) || !existingPositon.isClose(newPosition, 0.1f)) continue;
            return true;
        }
        return false;
    }
}

