/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.debug;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.interfaces.IRoutingDebugAdapter;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.network.packets.routingdebug.RoutingUpdateCanidatePipe;
import logisticspipes.network.packets.routingdebug.RoutingUpdateClearClient;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugCanidateList;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugClosedSet;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugFilters;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDoneDebug;
import logisticspipes.network.packets.routingdebug.RoutingUpdateInitDebug;
import logisticspipes.network.packets.routingdebug.RoutingUpdateSourcePipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.debug.RoutingTableDebugUpdateThread;
import logisticspipes.ticks.QueuedTasks;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class DebugController
implements IRoutingDebugAdapter {
    private static HashMap<ICommandSender, DebugController> instances = new HashMap();
    public List<WeakReference<ExitRoute>> cachedRoutes = new LinkedList<WeakReference<ExitRoute>>();
    private final ICommandSender sender;
    private Thread oldThread = null;
    private DebugWaitState state;
    private ExitRoute prevNode = null;
    private ExitRoute nextNode = null;
    private boolean pipeHandled = false;
    private PriorityQueue<ExitRoute> candidatesCost = null;
    private ArrayList<EnumSet<PipeRoutingConnectionType>> closedSet = null;
    private ArrayList<EnumMap<PipeRoutingConnectionType, List<List<IFilter>>>> filterList = null;

    private DebugController(ICommandSender sender) {
        this.sender = sender;
    }

    public static DebugController instance(ICommandSender sender) {
        if (instances.get(sender) == null) {
            instances.put(sender, new DebugController(sender));
        }
        return instances.get(sender);
    }

    public void debug(final ServerRouter serverRouter) {
        QueuedTasks.queueTask(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DebugController.this.state = DebugWaitState.LOOP;
                Thread tmp = new Thread(){

                    @Override
                    public void run() {
                        while (LPChatListener.existTaskFor(DebugController.this.sender.func_70005_c_())) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)DebugController.this.sender);
                        if (DebugController.this.oldThread != null) {
                            DebugController.this.oldThread.stop();
                        }
                        DebugController.this.oldThread = new RoutingTableDebugUpdateThread(){

                            @Override
                            public void run() {
                                serverRouter.CreateRouteTable(0, DebugController.this);
                                DebugController.this.oldThread = null;
                            }
                        };
                        DebugController.this.oldThread.setDaemon(true);
                        DebugController.this.oldThread.setName("RoutingTable update debug Thread");
                        DebugController.this.oldThread.start();
                    }
                };
                tmp.setDaemon(true);
                tmp.start();
                return null;
            }
        });
    }

    private void sendMsg(String message) {
        this.sender.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    private synchronized void wait(final String reson, boolean flag) {
        if (this.state == DebugWaitState.NOWAIT) {
            return;
        }
        this.state = DebugWaitState.LOOP;
        QueuedTasks.queueTask(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DebugController.this.sender.func_145747_a((IChatComponent)new ChatComponentText(reson));
                LPChatListener.addTask(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        DebugController.this.state = DebugWaitState.CONTINUE;
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), (EntityPlayer)DebugController.this.sender);
                        return true;
                    }
                }, DebugController.this.sender);
                return null;
            }
        });
        boolean exist = false;
        while (this.state == DebugWaitState.LOOP) {
            if (LPChatListener.existTaskFor(this.sender.func_70005_c_())) {
                exist = true;
            } else if (exist) {
                this.state = DebugWaitState.NOWAIT;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void start(PriorityQueue<ExitRoute> candidatesCost, ArrayList<EnumSet<PipeRoutingConnectionType>> closedSet, ArrayList<EnumMap<PipeRoutingConnectionType, List<List<IFilter>>>> filterList) {
        this.candidatesCost = candidatesCost;
        this.closedSet = closedSet;
        this.filterList = filterList;
        ExitRoute[] e = candidatesCost.toArray(new ExitRoute[0]);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateDebugCanidateList.class).setMsg(e), (EntityPlayer)this.sender);
        this.wait("Start?", true);
    }

    @Override
    public void nextPipe(ExitRoute lowestCostNode) {
        this.nextNode = lowestCostNode;
        if (!this.pipeHandled) {
            this.handledPipe(true);
        }
        this.pipeHandled = false;
        this.prevNode = lowestCostNode;
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateClearClient.class), (EntityPlayer)this.sender);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateSourcePipe.class).setExitRoute(lowestCostNode), (EntityPlayer)this.sender);
    }

    @Override
    public void handledPipe() {
        this.handledPipe(false);
    }

    public void handledPipe(boolean flag) {
        IRouter router;
        int i;
        for (i = 0; i < this.closedSet.size(); ++i) {
            EnumSet<PipeRoutingConnectionType> set = this.closedSet.get(i);
            if (set == null || (router = SimpleServiceLocator.routerManager.getRouter(i)) == null) continue;
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateDebugClosedSet.class).setPos(router.getLPPosition()).setSet(set), (EntityPlayer)this.sender);
        }
        for (i = 0; i < this.filterList.size(); ++i) {
            EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters = this.filterList.get(i);
            if (filters == null || (router = SimpleServiceLocator.routerManager.getRouter(i)) == null) continue;
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateDebugFilters.class).setPos(router.getLPPosition()).setFilters(filters), (EntityPlayer)this.sender);
        }
        ExitRoute[] e = this.candidatesCost.toArray(new ExitRoute[0]);
        if (flag) {
            LinkedList<ExitRoute> list = new LinkedList<ExitRoute>();
            list.add(this.nextNode);
            list.addAll(Arrays.asList(e));
            e = list.toArray(new ExitRoute[0]);
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateDebugCanidateList.class).setMsg(e), (EntityPlayer)this.sender);
        if (this.prevNode == null || this.prevNode.debug.isTraced) {
            this.wait("Continue with next pipe?", false);
        }
        this.pipeHandled = true;
    }

    @Override
    public void newCanidate(ExitRoute next) {
        next.debug.index = this.cachedRoutes.size();
        this.cachedRoutes.add(new WeakReference<ExitRoute>(next));
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateCanidatePipe.class).setExitRoute(next), (EntityPlayer)this.sender);
    }

    @Override
    public void stepOneDone() {
        this.sendMsg("Step One Finished");
    }

    @Override
    public void stepTwoDone() {
        this.sendMsg("Step Two Finished");
    }

    @Override
    public void done() {
        this.sendMsg("Update Done");
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateClearClient.class), (EntityPlayer)this.sender);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateDoneDebug.class), (EntityPlayer)this.sender);
        this.cachedRoutes.clear();
    }

    @Override
    public void init() {
        this.sendMsg("Initialising variables");
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(RoutingUpdateInitDebug.class), (EntityPlayer)this.sender);
    }

    @Override
    public void newFlagsForPipe(EnumSet<PipeRoutingConnectionType> newFlags) {
    }

    @Override
    public void filterList(EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters) {
    }

    @Override
    public boolean independent() {
        return true;
    }

    @Override
    public boolean isDebug() {
        return true;
    }

    public void untrace(int integer) {
        WeakReference<ExitRoute> ref = this.cachedRoutes.get(integer);
        if (ref != null && ref.get() != null) {
            ((ExitRoute)ref.get()).debug.isTraced = false;
            System.out.println("Did Untrack: " + ((ExitRoute)ref.get()).destination.getLPPosition());
        }
    }

    private static enum DebugWaitState {
        LOOP,
        CONTINUE,
        NOWAIT;

    }
}

