/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import java.io.IOException;
import java.util.UUID;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import net.minecraft.entity.player.EntityPlayer;

public class SecurityStationId
extends CoordinatesPacket {
    private UUID uuid;

    public SecurityStationId(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new SecurityStationId(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsSecurityTileEntity tile = this.getTile(player.field_70170_p, LogisticsSecurityTileEntity.class);
        if (tile != null) {
            tile.setClientUUID(this.getUuid());
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeLong(this.uuid.getMostSignificantBits());
        data.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.uuid = new UUID(data.readLong(), data.readLong());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SecurityStationId setUuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }
}

