/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ApiaristAnalyserModuleInHand;
import logisticspipes.network.guis.module.inpipe.ApiaristAnalyzerModuleSlot;
import logisticspipes.network.packets.module.ApiaristAnalyserMode;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleApiaristAnalyser
extends LogisticsGuiModule
implements IClientInformationProvider,
IModuleWatchReciver {
    private int ticksToAction = 100;
    private int currentTick = 0;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    public boolean extractMode = true;
    private SinkReply _sinkReply;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.extractMode = nbt.func_74767_n("extractMode");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("extractMode", this.extractMode);
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.APIARIST_Analyser, 0, true, false, 3, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier itemID, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        ItemStack item = itemID.makeNormalStack(1);
        if (SimpleServiceLocator.forestryProxy.isBee(item) && !SimpleServiceLocator.forestryProxy.isAnalysedBee(item) && this._service.canUseEnergy(3)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (this.extractMode) {
            if (++this.currentTick < this.ticksToAction) {
                return;
            }
            this.currentTick = 0;
            IInventoryUtil inv = this._service.getUnsidedInventory();
            if (inv == null) {
                return;
            }
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                Pair<Integer, SinkReply> reply;
                ItemStack item = inv.getStackInSlot(i);
                if (!SimpleServiceLocator.forestryProxy.isBee(item) || !SimpleServiceLocator.forestryProxy.isAnalysedBee(item) || (reply = this._service.hasDestination(ItemIdentifier.get(item), true, new ArrayList<Integer>())) == null || !this._service.useEnergy(6)) continue;
                this._service.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            }
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    public void setExtractMode(int mode) {
        if (this.getExtractMode() == mode) {
            return;
        }
        if (mode == 1) {
            this.extractMode = true;
        } else if (mode == 0) {
            this.extractMode = false;
        }
        this.modeChanged();
    }

    public int getExtractMode() {
        return this.extractMode ? 1 : 0;
    }

    public void modeChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            if (this.getSlot().isInWorld()) {
                MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ApiaristAnalyserMode.class).setMode(this.getExtractMode()).setModulePos(this), this.localModeWatchers);
            }
        } else {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ApiaristAnalyserMode.class).setMode(this.getExtractMode()).setModulePos(this));
        }
    }

    @Override
    public List<String> getClientInformation() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Extract Mode:");
        info.add(" - " + (this.extractMode ? "on" : "off"));
        return info;
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ApiaristAnalyserMode.class).setMode(this.getExtractMode()).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleApiaristAnalyser");
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ApiaristAnalyzerModuleSlot.class).setExtractorMode(this.getExtractMode());
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ApiaristAnalyserModuleInHand.class);
    }
}

