/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.creeperhost.gui;

import cpw.mods.fml.client.config.GuiSlider;
import java.util.ArrayList;
import net.creeperhost.creeperhost.Util;
import net.creeperhost.creeperhost.api.AvailableResult;
import net.creeperhost.creeperhost.api.Order;
import net.creeperhost.creeperhost.gui.GuiGetServer;
import net.creeperhost.creeperhost.paul.Callbacks;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiGeneralServerInfo
extends GuiGetServer {
    private GuiTextField nameField;
    private GuiSlider slotSlider;
    private long lastKeyTyped;
    private String acceptString = new String(Character.toChars(10004));
    private String denyString = new String(Character.toChars(10006));
    private boolean isAcceptable = false;
    private boolean nameChecked = false;
    private String message = "Name can not be blank";
    private static ResourceLocation lockIcon;

    public GuiGeneralServerInfo(int stepId, Order order) {
        super(stepId, order);
        lockIcon = new ResourceLocation("creeperhost", "textures/lock.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int halfWidth = this.field_146294_l / 2;
        int halfHeight = this.field_146295_m / 2;
        this.nameField = new GuiTextField(this.field_146289_q, halfWidth - 100, halfHeight - 30, 200, 20);
        this.nameField.func_146203_f(16);
        this.nameField.func_146180_a(this.order.name);
        final Order orderTemp = this.order;
        this.slotSlider = new GuiSlider(0, halfWidth - 100, halfHeight, 150, 20, Util.localize("slider.player_count", new Object[0]) + ": ", "", 1.0, 20.0, (double)this.order.playerAmount, false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                orderTemp.playerAmount = slider.getValueInt();
            }
        });
        this.slotSlider.field_146120_f = 200;
        this.field_146292_n.add(this.slotSlider);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.nameField.func_146178_a();
        final String nameToCheck = this.nameField.func_146179_b().trim();
        boolean isEmpty = nameToCheck.isEmpty();
        if (this.lastKeyTyped + 400L < System.currentTimeMillis() && !this.nameChecked) {
            this.nameChecked = true;
            if (isEmpty) {
                this.message = "Name cannot be blank";
                this.isAcceptable = false;
            } else {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        AvailableResult result = Callbacks.getNameAvailable(nameToCheck);
                        GuiGeneralServerInfo.this.isAcceptable = result.getSuccess();
                        GuiGeneralServerInfo.this.message = result.getMessage();
                    }
                };
                Thread thread = new Thread(task);
                thread.start();
            }
        }
        this.buttonNext.field_146124_l = !isEmpty && this.nameChecked && this.isAcceptable;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (!this.nameField.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        } else {
            this.nameChecked = false;
            this.message = "Name not yet checked";
            this.order.name = this.nameField.func_146179_b().trim();
            this.lastKeyTyped = System.currentTimeMillis();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int colour;
        String renderedString;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, Util.localize("info.server_name", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 45, -1);
        if (this.nameChecked && this.isAcceptable) {
            renderedString = this.acceptString;
            colour = 65280;
        } else {
            renderedString = this.denyString;
            colour = 0xFF0000;
        }
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        this.func_73731_b(this.field_146289_q, renderedString, this.field_146294_l / 4 + 53, this.field_146295_m / 4 - 14, colour);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(lockIcon);
        Gui.func_146110_a((int)(this.field_146294_l / 2 - 8), (int)(this.field_146295_m / 2 + 24), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        this.func_73732_a(this.field_146289_q, Util.localize("secure.line1", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + 45, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, Util.localize("secure.line2", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + 55, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, Util.localize("secure.line3", new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 + 65, 0xFFFFFF);
        this.nameField.func_146194_f();
        int xLeft = this.field_146294_l / 2 + 104;
        int xRight = xLeft + this.field_146289_q.func_78256_a(renderedString) * 2;
        int yTop = this.field_146295_m / 2 - 28;
        int yBottom = yTop + 13;
        if (mouseX >= xLeft && mouseX <= xRight && mouseY >= yTop && mouseY <= yBottom) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.message);
            this.drawHoveringText(list, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public String getStepName() {
        return Util.localize("gui.general_info", new Object[0]);
    }
}

