/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.lib.container.GenericItemBlock;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class SimpleDialerItemBlock
extends GenericItemBlock {
    public SimpleDialerItemBlock(Block block) {
        super(block);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        TileEntity te = world.func_147438_o(x, y, z);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (te instanceof MatterTransmitterTileEntity) {
            if (!world.field_72995_K) {
                MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
                if (!matterTransmitterTileEntity.checkAccess(player.getDisplayName())) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You have no access to this matter transmitter!"));
                    return true;
                }
                tagCompound.func_74768_a("transX", matterTransmitterTileEntity.field_145851_c);
                tagCompound.func_74768_a("transY", matterTransmitterTileEntity.field_145848_d);
                tagCompound.func_74768_a("transZ", matterTransmitterTileEntity.field_145849_e);
                tagCompound.func_74768_a("transDim", world.field_73011_w.field_76574_g);
                if (matterTransmitterTileEntity.isDialed()) {
                    Integer id = matterTransmitterTileEntity.getTeleportId();
                    boolean access = this.checkReceiverAccess(player, world, id);
                    if (!access) {
                        Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You have no access to the matter receiver!"));
                        return true;
                    }
                    tagCompound.func_74768_a("receiver", id.intValue());
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Receiver set!"));
                }
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Transmitter set!"));
            }
        } else if (te instanceof MatterReceiverTileEntity) {
            if (!world.field_72995_K) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                Integer id = matterReceiverTileEntity.getOrCalculateID();
                boolean access = this.checkReceiverAccess(player, world, id);
                if (!access) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You have no access to this matter receiver!"));
                    return true;
                }
                tagCompound.func_74768_a("receiver", id.intValue());
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + "Receiver set!"));
            }
        } else {
            return super.func_77648_a(stack, player, world, x, y, z, side, sx, sy, sz);
        }
        stack.func_77982_d(tagCompound);
        return true;
    }

    private boolean checkReceiverAccess(EntityPlayer player, World world, Integer id) {
        MatterReceiverTileEntity matterReceiverTileEntity;
        TileEntity recTe;
        World worldForDimension;
        TeleportDestination destination;
        boolean access = true;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        GlobalCoordinate coordinate = destinations.getCoordinateForId(id);
        if (coordinate != null && (destination = destinations.getDestination(coordinate)) != null && (worldForDimension = RfToolsDimensionManager.getWorldForDimension(destination.getDimension())) != null && (recTe = worldForDimension.func_147438_o(destination.getCoordinate().getX(), destination.getCoordinate().getY(), destination.getCoordinate().getZ())) instanceof MatterReceiverTileEntity && !(matterReceiverTileEntity = (MatterReceiverTileEntity)recTe).checkAccess(player.getDisplayName())) {
            access = false;
        }
        return access;
    }
}

