/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage.sorters;

import java.util.Comparator;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.storage.sorters.ItemSorter;
import mcjty.rftools.blocks.storage.sorters.NameItemSorter;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class DimletTypeItemSorter
implements ItemSorter {
    @Override
    public String getName() {
        return "type";
    }

    @Override
    public String getTooltip() {
        return "Sort on dimlet type";
    }

    @Override
    public int getU() {
        return 224;
    }

    @Override
    public int getV() {
        return 16;
    }

    @Override
    public Comparator<Pair<ItemStack, Integer>> getComparator() {
        return new Comparator<Pair<ItemStack, Integer>>(){

            @Override
            public int compare(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
                return DimletTypeItemSorter.compareTypes(o1, o2);
            }
        };
    }

    @Override
    public boolean isSameGroup(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        DimletType type2;
        DimletType type1 = DimletTypeItemSorter.getDimletType(o1);
        return type1 == (type2 = DimletTypeItemSorter.getDimletType(o2));
    }

    public static int compareTypes(Pair<ItemStack, Integer> o1, Pair<ItemStack, Integer> o2) {
        DimletType type1 = DimletTypeItemSorter.getDimletType(o1);
        DimletType type2 = DimletTypeItemSorter.getDimletType(o2);
        if (type1 == null) {
            if (type2 == null) {
                return NameItemSorter.compareNames(o1, o2);
            }
            return -1;
        }
        if (type2 == null) {
            return 1;
        }
        if (type1 == type2) {
            return NameItemSorter.compareNames(o1, o2);
        }
        return type1.compareTo(type2);
    }

    private static DimletType getDimletType(Pair<ItemStack, Integer> object) {
        DimletType type = null;
        if (((ItemStack)object.getKey()).func_77973_b() == DimletSetup.knownDimlet) {
            DimletKey key = KnownDimletConfiguration.getDimletKey((ItemStack)object.getKey(), null);
            type = key.getType();
        }
        return type;
    }

    @Override
    public String getGroupName(Pair<ItemStack, Integer> object) {
        DimletType type = DimletTypeItemSorter.getDimletType(object);
        return "Type " + (type == null ? "unknown" : type.dimletType.getName());
    }
}

