/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.api.config.ConfigGroup;
import ftb.utils.mod.FTBU;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldClient;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.LMWorldSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import latmod.lib.LMUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public abstract class LMWorld {
    public final Side side;
    public final ConfigGroup customCommonData;
    public final LMWorldSettings settings;

    public static LMWorld getWorld(Side s) {
        if (s.isServer()) {
            return LMWorldServer.inst;
        }
        return FTBU.proxy.getClientWorldLM();
    }

    public static LMWorld getWorld() {
        return LMWorld.getWorld(FTBLib.getEffectiveSide());
    }

    public LMWorld(Side s) {
        this.side = s;
        this.customCommonData = new ConfigGroup("custom_common_data");
        this.settings = new LMWorldSettings(this);
    }

    public abstract Map<Integer, ? extends LMPlayer> playerMap();

    public abstract World getMCWorld();

    public LMWorldServer getServerWorld() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public LMWorldClient getClientWorld() {
        return null;
    }

    public LMPlayer getPlayer(Object o) {
        if (o == null || o instanceof FakePlayer) {
            return null;
        }
        Map<Integer, ? extends LMPlayer> playerMap = this.playerMap();
        if (o instanceof Number || o instanceof LMPlayer) {
            int h = o.hashCode();
            if (h <= 0) {
                return null;
            }
            return playerMap.get(h);
        }
        if (o.getClass() == UUID.class) {
            UUID id = (UUID)o;
            for (LMPlayer lMPlayer : playerMap.values()) {
                if (!lMPlayer.getProfile().getId().equals(id)) continue;
                return lMPlayer;
            }
            return null;
        }
        if (o instanceof EntityPlayer) {
            if (this.side.isServer()) {
                for (LMPlayer lMPlayer : playerMap.values()) {
                    if (!lMPlayer.isOnline() || lMPlayer.getPlayer() != o) continue;
                    return lMPlayer;
                }
            }
            return this.getPlayer(((EntityPlayer)o).func_146103_bH().getId());
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (LMPlayer lMPlayer : playerMap.values()) {
                if (!lMPlayer.getProfile().getName().equalsIgnoreCase(s)) continue;
                return lMPlayer;
            }
            return this.getPlayer(LMUtils.fromString((String)s));
        }
        return null;
    }

    public List<? extends LMPlayer> getAllOnlinePlayers() {
        ArrayList<LMPlayer> l = new ArrayList<LMPlayer>();
        for (LMPlayer lMPlayer : this.playerMap().values()) {
            if (!lMPlayer.isOnline()) continue;
            l.add(lMPlayer);
        }
        return l;
    }

    public int getPlayerID(Object o) {
        if (o == null) {
            return 0;
        }
        LMPlayer p = this.getPlayer(o);
        return p == null ? 0 : p.getPlayerID();
    }

    public int[] getAllPlayerIDs() {
        int[] ai = new int[this.playerMap().size()];
        int id = -1;
        for (LMPlayer lMPlayer : this.playerMap().values()) {
            ai[++id] = lMPlayer.getPlayerID();
        }
        return ai;
    }

    public List<LMPlayerServer> getServerPlayers() {
        ArrayList<LMPlayerServer> l = new ArrayList<LMPlayerServer>();
        for (LMPlayer lMPlayer : this.playerMap().values()) {
            l.add(lMPlayer.toPlayerMP());
        }
        return l;
    }
}

