/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.forbidden.items.tools;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.forbidden.Forbidden;
import fox.spiteful.forbidden.compat.Compat;
import fox.spiteful.forbidden.potions.DarkPotions;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import thaumcraft.api.IRepairable;

public class ItemDragonslayer
extends ItemSword
implements IRepairable {
    public IIcon icon;
    public Item repair;

    public ItemDragonslayer() {
        super(Item.ToolMaterial.EMERALD);
        this.func_77637_a(Forbidden.tab);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("forbidden:dragonslayer");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.icon;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.epic;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        return stack2.func_77973_b() == this.repair || super.func_82789_a(stack, stack2);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase player) {
        stack.func_77972_a(1, player);
        if (!victim.field_70170_p.field_72995_K && Compat.dargon & ItemDragonslayer.isDragon((Entity)victim)) {
            ItemDragonslayer.absoluteDamage(victim, new EntityDamageSource("dragonslayer", (Entity)player).func_76348_h(), Math.max(4.0f, victim.func_110138_aP() / 5.0f));
            if (victim instanceof EntityPlayer) {
                EntityPlayer target = (EntityPlayer)victim;
                for (int x = 0; x < 5; ++x) {
                    ItemStack equip;
                    if (target.func_71124_b(x) == null || !((equip = target.func_71124_b(x)).func_77973_b() instanceof IEnergyContainerItem)) continue;
                    IEnergyContainerItem battery = (IEnergyContainerItem)equip.func_77973_b();
                    battery.extractEnergy(equip, battery.getMaxEnergyStored(equip) / 20, false);
                }
            }
            victim.func_70690_d(new PotionEffect(DarkPotions.dragonwrack.func_76396_c(), 300));
        }
        return true;
    }

    public static boolean isDragon(Entity target) {
        if (target == null) {
            return false;
        }
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            for (int x = 1; x < 5; ++x) {
                GameRegistry.UniqueIdentifier id;
                if (player.func_71124_b(x) == null || (id = GameRegistry.findUniqueIdentifierFor((Item)player.func_71124_b(x).func_77973_b())) == null || !id.modId.equals("DraconicEvolution")) continue;
                return true;
            }
        } else if (target instanceof EntityDragon || target.func_70005_c_().toLowerCase().contains("dragon") || target.func_70005_c_().toLowerCase().contains("drake") || target.func_70005_c_().toLowerCase().contains("dracon")) {
            return true;
        }
        return false;
    }

    public static void absoluteDamage(EntityLivingBase target, DamageSource src, float damage) {
        target.func_110142_aN().func_94547_a(src, target.func_110143_aJ(), damage);
        target.func_70606_j(target.func_110143_aJ() - damage);
        if (target.func_110143_aJ() < 1.0f) {
            target.func_70645_a(src);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGetHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack equip;
        if (event.entityLiving instanceof EntityPlayer && event.source.func_76346_g() != null && (equip = (player = (EntityPlayer)event.entityLiving).func_71045_bC()) != null && equip.func_77973_b() == this && ItemDragonslayer.isDragon(event.source.func_76346_g())) {
            event.ammount = Math.min(event.ammount, 3.0f);
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack equip;
        if (event.entityLiving instanceof EntityPlayer && event.source.func_76346_g() != null && (equip = (player = (EntityPlayer)event.entityLiving).func_71045_bC()) != null && player.func_71039_bw() && equip.func_77973_b() == this && ItemDragonslayer.isDragon(event.source.func_76346_g())) {
            event.setCanceled(true);
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer other = (EntityPlayer)event.source.func_76346_g();
                other.func_70690_d(new PotionEffect(DarkPotions.dragonwrack.func_76396_c(), 300));
                for (int x = 0; x < 5; ++x) {
                    ItemStack gear;
                    if (other.func_71124_b(x) == null || !((gear = other.func_71124_b(x)).func_77973_b() instanceof IEnergyContainerItem)) continue;
                    IEnergyContainerItem battery = (IEnergyContainerItem)gear.func_77973_b();
                    battery.extractEnergy(gear, battery.getMaxEnergyStored(gear) / 50, false);
                }
            }
        }
    }
}

