/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ShaderCaseRailgun
extends ShaderCase {
    public String additionalTexture = null;
    public IIcon i_railgunBase;
    public IIcon i_railgunOverlay;
    public IIcon i_railgunUncoloured;
    public IIcon i_railgunAdditional;

    public ShaderCaseRailgun(String overlayType, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        super(overlayType, colourGrip, colourPrimary, colourSecondary, "immersiveengineering:shaders/railgun_");
        this.additionalTexture = additionalTexture;
    }

    @Override
    public String getShaderType() {
        return "railgun";
    }

    @Override
    public int getPasses(ItemStack shader, ItemStack item, String modelPart) {
        if (modelPart.equals("sled") || modelPart.equals("wires") || modelPart.equals("tubes")) {
            return 1;
        }
        boolean hasUncoloured = modelPart.equals("barrel") || modelPart.equals("frame") || modelPart.equals("upgrade_speed") || modelPart.equals("upgrade_scope");
        return 2 + (this.additionalTexture != null ? 1 : 0) + (hasUncoloured ? 1 : 0);
    }

    @Override
    public IIcon getReplacementIcon(ItemStack shader, ItemStack item, String modelPart, int pass) {
        boolean hasUncoloured;
        int maxPass = this.getPasses(shader, item, modelPart);
        boolean bl = hasUncoloured = modelPart.equals("sled") || modelPart.equals("wires") || modelPart.equals("tubes") || modelPart.equals("frame") || modelPart.equals("barrel") || modelPart.equals("upgrade_speed") || modelPart.equals("upgrade_scope");
        if (hasUncoloured && pass == maxPass - 1) {
            return this.i_railgunUncoloured;
        }
        if (pass == maxPass - (hasUncoloured ? 2 : 1) && this.i_railgunAdditional != null) {
            return this.i_railgunAdditional;
        }
        return pass == 0 ? this.i_railgunBase : this.i_railgunOverlay;
    }

    @Override
    public int[] getRGBAColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        boolean hasUncoloured;
        int maxPass = this.getPasses(shader, item, modelPart);
        boolean bl = hasUncoloured = modelPart.equals("sled") || modelPart.equals("wires") || modelPart.equals("tubes") || modelPart.equals("frame") || modelPart.equals("barrel") || modelPart.equals("upgrade_speed") || modelPart.equals("upgrade_scope");
        if (hasUncoloured && pass == maxPass - 1) {
            return defaultWhite;
        }
        if (pass == maxPass - (hasUncoloured ? 2 : 1) && this.i_railgunAdditional != null) {
            return this.colourOverlay;
        }
        int i = this.getTextureType(modelPart, pass);
        if (i == 0) {
            return this.colourUnderlying;
        }
        if (i == 1) {
            return this.colourPrimary;
        }
        if (i == 2) {
            return this.colourSecondary;
        }
        return defaultWhite;
    }

    public int getTextureType(String modelPart, int pass) {
        if (modelPart.equals("grip")) {
            return pass == 0 ? 0 : pass + 1;
        }
        return pass + 1;
    }

    @Override
    public void stichTextures(IIconRegister ir, int sheetID) {
        if (sheetID == 1) {
            this.i_railgunBase = ir.func_94245_a("immersiveengineering:shaders/railgun_0");
            this.i_railgunOverlay = ir.func_94245_a(this.baseTexturePath + "1_" + this.overlayType);
            this.i_railgunUncoloured = ir.func_94245_a("immersiveengineering:shaders/railgun_uncoloured");
            if (this.additionalTexture != null) {
                this.i_railgunAdditional = ir.func_94245_a(this.baseTexturePath + this.additionalTexture);
            }
        }
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre, boolean inventory) {
    }
}

