/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import java.util.ArrayList;
import net.minecraft.util.StatCollector;

public abstract class SymbolBase
implements IAgeSymbol {
    protected final String identifier;
    private ArrayList<GrammarGenerator.Rule> rules;
    private String[] words;

    public SymbolBase(String identifier) {
        this.identifier = identifier;
    }

    public void setWords(String[] words) {
        this.words = words;
    }

    public IAgeSymbol setCardRank(Integer cardrank) {
        if (cardrank == null) {
            return this;
        }
        InternalAPI.symbolValues.setSymbolCardRank(this, cardrank);
        return this;
    }

    public final ArrayList<GrammarGenerator.Rule> getRules() {
        ArrayList<GrammarGenerator.Rule> out = this.createRules();
        if (this.rules != null) {
            if (out == null) {
                out = new ArrayList();
            }
            out.addAll(this.rules);
        }
        return out;
    }

    protected ArrayList<GrammarGenerator.Rule> createRules() {
        return null;
    }

    public void addRule(GrammarGenerator.Rule rule) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        this.rules.add(rule);
    }

    @Override
    public final String identifier() {
        return this.identifier;
    }

    public String getUnlocalizedName() {
        return "myst.symbol." + this.identifier();
    }

    @Override
    public String displayName() {
        return StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".name"));
    }

    @Override
    public abstract void registerLogic(AgeDirector var1, long var2);

    @Override
    public int instabilityModifier(int count) {
        return 0;
    }

    @Override
    public final String[] getPoem() {
        return this.words;
    }
}

