/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.portal;

import com.xcompwiz.mystcraft.data.ModBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class PortalUtils {
    public static Block getPortalBlock() {
        return ModBlocks.portal;
    }

    public static Block getFrameBlock() {
        return ModBlocks.crystal;
    }

    public static Block getReceptacleBlock() {
        return ModBlocks.receptacle;
    }

    public static int isValidLinkPortalBlock(Block block) {
        if (block == PortalUtils.getFrameBlock()) {
            return 1;
        }
        if (block == PortalUtils.getPortalBlock()) {
            return 1;
        }
        return 0;
    }

    public static void validatePortal(World world, ChunkCoordinates start) {
        if (world.field_72995_K) {
            return;
        }
        LinkedList<ChunkCoordinates> blocks = new LinkedList<ChunkCoordinates>();
        blocks.add(start);
        while (blocks.size() > 0) {
            ChunkCoordinates coords = (ChunkCoordinates)blocks.remove(0);
            if (world.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) != PortalUtils.getPortalBlock()) continue;
            PortalUtils.validatePortal(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, blocks);
        }
    }

    public static void firePortal(World world, int i, int j, int k) {
        ChunkCoordinates coord = PortalUtils.getReceptacleBase(i, j, k, world.func_72805_g(i, j, k));
        PortalUtils.onpulse(world, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
        PortalUtils.pathto(world, i, j, k);
    }

    public static void shutdownPortal(World world, int i, int j, int k) {
        PortalUtils.unpath(world, i, j, k);
    }

    public static ChunkCoordinates getReceptacleBase(int i, int j, int k, int blockMetadata) {
        if (blockMetadata == 0) {
            return new ChunkCoordinates(i, j + 1, k);
        }
        if (blockMetadata == 1) {
            return new ChunkCoordinates(i, j - 1, k);
        }
        if (blockMetadata == 2) {
            return new ChunkCoordinates(i, j, k + 1);
        }
        if (blockMetadata == 3) {
            return new ChunkCoordinates(i, j, k - 1);
        }
        if (blockMetadata == 4) {
            return new ChunkCoordinates(i + 1, j, k);
        }
        if (blockMetadata == 5) {
            return new ChunkCoordinates(i - 1, j, k);
        }
        return new ChunkCoordinates(i, j, k);
    }

    private static void pathto(World world, int i, int j, int k) {
        ChunkCoordinates coords;
        LinkedList<ChunkCoordinates> blocks = new LinkedList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> portals = new LinkedList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> repath = new LinkedList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> redraw = new LinkedList<ChunkCoordinates>();
        blocks.add(new ChunkCoordinates(i, j, k));
        while (portals.size() > 0 || blocks.size() > 0) {
            while (blocks.size() > 0) {
                coords = (ChunkCoordinates)blocks.remove(0);
                PortalUtils.directPortal(world, coords.field_71574_a + 1, coords.field_71572_b + 0, coords.field_71573_c + 0, 5, blocks, portals);
                PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b + 1, coords.field_71573_c + 0, 1, blocks, portals);
                PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c + 1, 3, blocks, portals);
                PortalUtils.directPortal(world, coords.field_71574_a - 1, coords.field_71572_b + 0, coords.field_71573_c + 0, 6, blocks, portals);
                PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b - 1, coords.field_71573_c + 0, 2, blocks, portals);
                PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c - 1, 4, blocks, portals);
                redraw.add(coords);
            }
            if (portals.size() <= 0) continue;
            coords = (ChunkCoordinates)portals.remove(0);
            PortalUtils.directPortal(world, coords.field_71574_a + 1, coords.field_71572_b + 0, coords.field_71573_c + 0, 5, blocks, portals);
            PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b + 1, coords.field_71573_c + 0, 1, blocks, portals);
            PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c + 1, 3, blocks, portals);
            PortalUtils.directPortal(world, coords.field_71574_a - 1, coords.field_71572_b + 0, coords.field_71573_c + 0, 6, blocks, portals);
            PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b - 1, coords.field_71573_c + 0, 2, blocks, portals);
            PortalUtils.directPortal(world, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c - 1, 4, blocks, portals);
            if (world.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) != PortalUtils.getPortalBlock()) continue;
            repath.add(coords);
        }
        while (repath.size() > 0) {
            coords = (ChunkCoordinates)repath.remove(0);
            if (world.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) != PortalUtils.getPortalBlock()) continue;
            if (!PortalUtils.isPortalBlockStable(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) {
                PortalUtils.repathNeighbors(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                world.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Blocks.field_150350_a, 0, 0);
                PortalUtils.addSurrounding(repath, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                continue;
            }
            redraw.add(coords);
        }
        for (ChunkCoordinates coords2 : redraw) {
            if (!world.func_72899_e(coords2.field_71574_a, coords2.field_71572_b, coords2.field_71573_c)) continue;
            world.func_147471_g(coords2.field_71574_a, coords2.field_71572_b, coords2.field_71573_c);
            world.func_147459_d(coords2.field_71574_a, coords2.field_71572_b, coords2.field_71573_c, world.func_147439_a(coords2.field_71574_a, coords2.field_71572_b, coords2.field_71573_c));
        }
    }

    private static void repathNeighbors(World world, int i, int j, int k) {
        TileEntity tileentity = PortalUtils.getTileEntity((IBlockAccess)world, i, j, k);
        LinkedList<ChunkCoordinates> blocks = new LinkedList<ChunkCoordinates>();
        blocks.add(new ChunkCoordinates(i, j, k));
        world.func_72921_c(i, j, k, 8, 2);
        while (blocks.size() > 0) {
            ChunkCoordinates coords = (ChunkCoordinates)blocks.remove(0);
            PortalUtils.redirectPortal(world, tileentity, coords.field_71574_a + 1, coords.field_71572_b + 0, coords.field_71573_c + 0, 5, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.field_71574_a + 0, coords.field_71572_b + 1, coords.field_71573_c + 0, 1, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c + 1, 3, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.field_71574_a - 1, coords.field_71572_b + 0, coords.field_71573_c + 0, 6, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.field_71574_a + 0, coords.field_71572_b - 1, coords.field_71573_c + 0, 2, blocks);
            PortalUtils.redirectPortal(world, tileentity, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c - 1, 4, blocks);
        }
    }

    private static void redirectPortal(World world, TileEntity tileentity, int i, int j, int k, int meta, List<ChunkCoordinates> blocks) {
        if (PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i, j, k)) == 0) {
            return;
        }
        if (world.func_72805_g(i, j, k) == meta) {
            for (int m = 1; m < 7; ++m) {
                if (m == meta) continue;
                world.func_72921_c(i, j, k, m, 2);
                TileEntity local = PortalUtils.getTileEntity((IBlockAccess)world, i, j, k);
                if (local != tileentity && (local == null || tileentity != null)) continue;
                return;
            }
            world.func_72921_c(i, j, k, 0, 2);
        }
    }

    private static void unpath(World world, int i, int j, int k) {
        LinkedList<ChunkCoordinates> blocks = new LinkedList<ChunkCoordinates>();
        LinkedList<ChunkCoordinates> notify = new LinkedList<ChunkCoordinates>();
        blocks.add(new ChunkCoordinates(i, j, k));
        while (blocks.size() > 0) {
            ChunkCoordinates coords = (ChunkCoordinates)blocks.remove(0);
            PortalUtils.depolarize(world, coords.field_71574_a + 1, coords.field_71572_b + 0, coords.field_71573_c + 0, blocks);
            PortalUtils.depolarize(world, coords.field_71574_a + 0, coords.field_71572_b + 1, coords.field_71573_c + 0, blocks);
            PortalUtils.depolarize(world, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c + 1, blocks);
            PortalUtils.depolarize(world, coords.field_71574_a - 1, coords.field_71572_b + 0, coords.field_71573_c + 0, blocks);
            PortalUtils.depolarize(world, coords.field_71574_a + 0, coords.field_71572_b - 1, coords.field_71573_c + 0, blocks);
            PortalUtils.depolarize(world, coords.field_71574_a + 0, coords.field_71572_b + 0, coords.field_71573_c - 1, blocks);
            notify.add(coords);
        }
        for (ChunkCoordinates coords : notify) {
            if (!world.func_72899_e(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) continue;
            world.func_147471_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            world.func_147459_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, world.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c));
        }
    }

    private static void onpulse(World world, int i, int j, int k) {
        ChunkCoordinates coords;
        LinkedList<ChunkCoordinates> set = new LinkedList<ChunkCoordinates>();
        Stack<ChunkCoordinates> validate = new Stack<ChunkCoordinates>();
        PortalUtils.addSurrounding(set, i, j, k);
        while (set.size() > 0) {
            coords = set.remove(0);
            PortalUtils.expandPortal(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, set, validate);
        }
        while (validate.size() > 0) {
            coords = (ChunkCoordinates)validate.pop();
            i = coords.field_71574_a;
            j = coords.field_71572_b;
            k = coords.field_71573_c;
            if (PortalUtils.checkPortalTension(world, i, j, k)) continue;
            world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 0);
        }
    }

    private static boolean isPortalBlockStable(World world, int i, int j, int k) {
        if (world.field_72995_K) {
            return true;
        }
        if (!PortalUtils.checkPortalTension(world, i, j, k)) {
            return false;
        }
        return PortalUtils.getTileEntity((IBlockAccess)world, i, j, k) != null;
    }

    private static boolean checkPortalTension(World world, int i, int j, int k) {
        if (world.field_72995_K) {
            return true;
        }
        int score = 0;
        if (PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 1, j + 0, k + 0)) > 0 && PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i - 1, j + 0, k + 0)) > 0) {
            ++score;
        }
        if (PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j + 1, k + 0)) > 0 && PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j - 1, k + 0)) > 0) {
            ++score;
        }
        if (PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j + 0, k + 1)) > 0 && PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j + 0, k - 1)) > 0) {
            ++score;
        }
        return score > 1;
    }

    private static void validatePortal(World world, int i, int j, int k, Collection<ChunkCoordinates> blocks) {
        if (!PortalUtils.isPortalBlockStable(world, i, j, k)) {
            world.func_147449_b(i, j, k, Blocks.field_150350_a);
            PortalUtils.addSurrounding(blocks, i, j, k);
        }
    }

    private static void addSurrounding(Collection<ChunkCoordinates> set, int i, int j, int k) {
        set.add(new ChunkCoordinates(i + 1, j + 0, k + 0));
        set.add(new ChunkCoordinates(i - 1, j + 0, k + 0));
        set.add(new ChunkCoordinates(i + 0, j + 1, k + 0));
        set.add(new ChunkCoordinates(i + 0, j - 1, k + 0));
        set.add(new ChunkCoordinates(i + 0, j + 0, k + 1));
        set.add(new ChunkCoordinates(i + 0, j + 0, k - 1));
        set.add(new ChunkCoordinates(i + 1, j + 1, k + 0));
        set.add(new ChunkCoordinates(i - 1, j + 1, k + 0));
        set.add(new ChunkCoordinates(i + 1, j - 1, k + 0));
        set.add(new ChunkCoordinates(i - 1, j - 1, k + 0));
        set.add(new ChunkCoordinates(i + 0, j + 1, k + 1));
        set.add(new ChunkCoordinates(i + 0, j + 1, k - 1));
        set.add(new ChunkCoordinates(i + 0, j - 1, k + 1));
        set.add(new ChunkCoordinates(i + 0, j - 1, k - 1));
        set.add(new ChunkCoordinates(i + 1, j + 0, k + 1));
        set.add(new ChunkCoordinates(i - 1, j + 0, k + 1));
        set.add(new ChunkCoordinates(i + 1, j + 0, k - 1));
        set.add(new ChunkCoordinates(i - 1, j + 0, k - 1));
    }

    private static void expandPortal(World world, int i, int j, int k, Collection<ChunkCoordinates> set, Stack<ChunkCoordinates> created) {
        if (!world.func_147437_c(i, j, k)) {
            return;
        }
        int score = PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 1, j + 0, k + 0)) + PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i - 1, j + 0, k + 0)) + PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j + 1, k + 0)) + PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j - 1, k + 0)) + PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j + 0, k + 1)) + PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i + 0, j + 0, k - 1));
        if (score > 1) {
            world.func_147465_d(i, j, k, PortalUtils.getPortalBlock(), 0, 0);
            created.push(new ChunkCoordinates(i, j, k));
            PortalUtils.addSurrounding(set, i, j, k);
        }
    }

    private static void directPortal(World world, int i, int j, int k, int meta, List<ChunkCoordinates> blocks, List<ChunkCoordinates> portals) {
        if (PortalUtils.isValidLinkPortalBlock(world.func_147439_a(i, j, k)) == 0) {
            return;
        }
        if (world.func_72805_g(i, j, k) != 0) {
            return;
        }
        world.func_72921_c(i, j, k, meta, 0);
        if (world.func_147439_a(i, j, k) == PortalUtils.getPortalBlock()) {
            portals.add(new ChunkCoordinates(i, j, k));
        } else {
            blocks.add(new ChunkCoordinates(i, j, k));
        }
    }

    private static void depolarize(World world, int i, int j, int k, List<ChunkCoordinates> blocks) {
        Block block = world.func_147439_a(i, j, k);
        if (PortalUtils.isValidLinkPortalBlock(block) == 0) {
            return;
        }
        if (world.func_72805_g(i, j, k) == 0) {
            return;
        }
        world.func_72921_c(i, j, k, 0, 0);
        if (block == PortalUtils.getPortalBlock() && !PortalUtils.isPortalBlockStable(world, i, j, k)) {
            world.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 2);
        }
        blocks.add(new ChunkCoordinates(i, j, k));
    }

    public static TileEntity getTileEntity(IBlockAccess blockaccess, int i, int j, int k) {
        HashSet<ChunkCoordinates> visited = new HashSet<ChunkCoordinates>();
        Block block = blockaccess.func_147439_a(i, j, k);
        while (block != PortalUtils.getReceptacleBlock()) {
            if (PortalUtils.isValidLinkPortalBlock(block) == 0) {
                return null;
            }
            ChunkCoordinates pos = new ChunkCoordinates(i, j, k);
            if (!visited.add(pos)) {
                return null;
            }
            int meta = blockaccess.func_72805_g(i, j, k);
            if (meta == 0) {
                return null;
            }
            if (meta == 1) {
                --j;
            } else if (meta == 2) {
                ++j;
            } else if (meta == 3) {
                --k;
            } else if (meta == 4) {
                ++k;
            } else if (meta == 5) {
                --i;
            } else if (meta == 6) {
                ++i;
            } else {
                return null;
            }
            block = blockaccess.func_147439_a(i, j, k);
        }
        return blockaccess.func_147438_o(i, j, k);
    }
}

