/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.EventHandler;
import hardcorequesting.FileVersion;
import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestDataTaskReputationKill;
import hardcorequesting.quests.QuestTaskMob;
import hardcorequesting.quests.QuestTaskReputation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class QuestTaskReputationKill
extends QuestTaskReputation {
    private int kills;

    public QuestTaskReputationKill(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription, 20);
        this.register(EventHandler.Type.DEATH);
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayer killer = QuestTaskMob.getKiller(event);
        if (killer != null && this.parent.isEnabled(killer) && this.parent.isAvailable(killer) && this.isVisible(killer) && !this.isCompleted(killer) && !killer.equals((Object)event.entityLiving) && event.entityLiving instanceof EntityPlayer && this.isPlayerInRange((EntityPlayer)event.entityLiving)) {
            QuestDataTaskReputationKill killData = (QuestDataTaskReputationKill)this.getData(killer);
            if (killData.kills < this.kills) {
                ++killData.kills;
                if (killData.kills == this.kills) {
                    this.completeTask(killer.func_146103_bH().getName());
                }
                this.parent.sendUpdatedDataToTeam(killer);
            }
        }
    }

    @Override
    protected EntityPlayer getPlayerForRender(EntityPlayer player) {
        return null;
    }

    @Override
    public void write(DataWriter dw, QuestDataTask task, boolean light) {
        super.write(dw, task, light);
        dw.writeData(((QuestDataTaskReputationKill)task).kills, DataBitHelper.DEATHS);
    }

    @Override
    public void read(DataReader dr, QuestDataTask task, FileVersion version, boolean light) {
        super.read(dr, task, version, light);
        ((QuestDataTaskReputationKill)task).kills = dr.readData(DataBitHelper.DEATHS);
    }

    @Override
    public void save(DataWriter dw) {
        super.save(dw);
        dw.writeData(this.kills, DataBitHelper.DEATHS);
    }

    @Override
    public void load(DataReader dr, FileVersion version) {
        super.load(dr, version);
        this.kills = dr.readData(DataBitHelper.DEATHS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        super.draw(gui, player, mX, mY);
        int killCount = ((QuestDataTaskReputationKill)this.getData((EntityPlayer)player)).kills;
        if (Quest.isEditing) {
            gui.drawString(gui.getLinesFromText(Translator.translate(this.kills != 1, "hqm.repKil.kills", killCount, this.kills), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        } else {
            gui.drawString(gui.getLinesFromText(killCount == this.kills ? (Object)((Object)GuiColor.GREEN) + Translator.translate(this.kills != 1, "hqm.repKil.killCount", this.kills) : Translator.translate("hqm.repKil.killCountOutOf", killCount, this.kills), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        }
    }

    @Override
    public void onUpdate(EntityPlayer player, DataReader dr) {
    }

    @Override
    public float getCompletedRatio(String playerName) {
        return (float)((QuestDataTaskReputationKill)this.getData((String)playerName)).kills / (float)this.kills;
    }

    @Override
    public void mergeProgress(String playerName, QuestDataTask own, QuestDataTask other) {
        ((QuestDataTaskReputationKill)own).kills = Math.max(((QuestDataTaskReputationKill)own).kills, ((QuestDataTaskReputationKill)other).kills);
        if (((QuestDataTaskReputationKill)own).kills == this.kills) {
            this.completeTask(playerName);
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        ((QuestDataTaskReputationKill)own).kills = ((QuestDataTaskReputationKill)other).kills;
    }

    @Override
    public void autoComplete(String playerName) {
        this.kills = ((QuestDataTaskReputationKill)this.getData((String)playerName)).kills;
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskReputationKill.class;
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }
}

