/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeresources.config.Settings;
import jeresources.json.ProfilingAdapter;
import jeresources.profiling.ChunkGetter;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingExecutor;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class Profiler
implements Runnable {
    private final ConcurrentMap<Integer, ProfiledDimensionData> allDimensionData;
    private final ProfilingTimer timer;
    private final ICommandSender sender;
    private final int chunkCount;
    private final boolean allWorlds;
    private ProfilingExecutor currentExecutor;
    private static Profiler currentProfiler;

    private Profiler(ICommandSender sender, int chunkCount, boolean allWorlds) {
        this.sender = sender;
        this.allDimensionData = new ConcurrentHashMap<Integer, ProfiledDimensionData>();
        this.chunkCount = chunkCount;
        this.timer = new ProfilingTimer(sender, chunkCount);
        this.allWorlds = allWorlds;
    }

    @Override
    public void run() {
        LogHelper.warn("There will be messages about world gen lag during the profiling, you can ignore these as that is what you get when profiling.", new Object[0]);
        if (!this.allWorlds) {
            Entity sendEnt = this.sender.func_174793_f();
            int dimId = sendEnt.field_71093_bK;
            this.profileWorld(dimId);
        } else {
            for (Integer dimId : DimensionManager.getStaticDimensionIDs()) {
                this.profileWorld(dimId);
            }
        }
        this.writeData();
        this.timer.complete();
    }

    private void profileWorld(int dimId) {
        ProfilingExecutor executor;
        WorldServer world = DimensionManager.getWorld((int)dimId);
        if (world == null) {
            DimensionManager.initDimension((int)dimId);
            world = DimensionManager.getWorld((int)dimId);
        }
        if (world == null) {
            String msg = "Unable to profile dimension " + dimId + ".  There is no world for it.";
            LogHelper.error(msg, new Object[0]);
            this.sender.func_145747_a((ITextComponent)new TextComponentString(msg));
            return;
        }
        WorldServer worldServer = world;
        String msg = "Inspecting dimension " + dimId + ": " + worldServer.field_73011_w.func_186058_p().func_186065_b() + ". ";
        this.sender.func_145747_a((ITextComponent)new TextComponentString(msg));
        msg = msg + "The world thinks it is dimension " + worldServer.field_73011_w.getDimension() + ".";
        LogHelper.info(msg, new Object[0]);
        if (Settings.excludedDimensions.contains(dimId)) {
            msg = "Skipped dimension " + dimId + " during profiling";
            LogHelper.info(msg, new Object[0]);
            this.sender.func_145747_a((ITextComponent)new TextComponentString(msg));
            return;
        }
        this.currentExecutor = executor = new ProfilingExecutor(this);
        this.allDimensionData.put(dimId, new ProfiledDimensionData());
        DummyWorld dummyWorld = new DummyWorld(worldServer);
        dummyWorld.func_175643_b();
        ChunkGetter chunkGetter = new ChunkGetter(this.chunkCount, dummyWorld, executor);
        worldServer.func_152344_a((Runnable)chunkGetter);
        executor.awaitTermination();
        this.currentExecutor = null;
        dummyWorld.clearChunks();
        DimensionManager.setWorld((int)dimId, (WorldServer)worldServer, (MinecraftServer)Minecraft.func_71410_x().func_71401_C());
    }

    public ProfilingTimer getTimer() {
        return this.timer;
    }

    public ConcurrentMap<Integer, ProfiledDimensionData> getAllDimensionData() {
        return this.allDimensionData;
    }

    private void writeData() {
        HashMap<Integer, ProfilingAdapter.DimensionData> allData = new HashMap<Integer, ProfilingAdapter.DimensionData>();
        for (Integer dim : this.allDimensionData.keySet()) {
            ProfiledDimensionData profiledData = (ProfiledDimensionData)this.allDimensionData.get(dim);
            ProfilingAdapter.DimensionData data = new ProfilingAdapter.DimensionData();
            data.dropsMap = profiledData.dropsMap;
            data.silkTouchMap = profiledData.silkTouchMap;
            for (Map.Entry entry : profiledData.distributionMap.entrySet()) {
                Float[] array = new Float[256];
                for (int i = 0; i < 256; ++i) {
                    array[i] = Float.valueOf((float)((Integer[])entry.getValue())[i].intValue() * 1.0f / (float)this.timer.getBlocksPerLayer(dim));
                }
                data.distribution.put((String)entry.getKey(), array);
            }
            allData.put(dim, data);
        }
        ProfilingAdapter.write(allData);
    }

    public static boolean init(ICommandSender sender, int chunks, boolean allWorlds) {
        if (currentProfiler != null && !Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        currentProfiler = new Profiler(sender, chunks, allWorlds);
        new Thread(currentProfiler).start();
        return true;
    }

    public static boolean stop() {
        if (currentProfiler == null || Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        if (Profiler.currentProfiler.currentExecutor != null) {
            Profiler.currentProfiler.currentExecutor.shutdownNow();
        }
        currentProfiler.writeData();
        return true;
    }
}

