/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.enchantment;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.entry.EnchantmentEntry;
import jeresources.registry.EnchantmentRegistry;
import jeresources.util.Font;
import jeresources.util.TranslationHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class EnchantmentWrapper
implements IRecipeWrapper {
    private static final int ENTRIES_PER_PAGE = 11;
    private static final int ENCHANT_X = 35;
    private static final int FIRST_ENCHANT_Y = 7;
    private static final int SPACING_Y = 10;
    private static final int PAGE_X = 55;
    private static final int PAGE_Y = 120;
    private static final int CYCLE_TIME = 2;
    private final ItemStack itemStack;
    private final List<EnchantmentEntry> enchantments;
    private final int lastSet;
    private int set;
    private int nextCycle;

    @Nullable
    public static EnchantmentWrapper create(@Nonnull ItemStack itemStack) {
        LinkedList<EnchantmentEntry> enchantments = new LinkedList<EnchantmentEntry>(EnchantmentRegistry.getInstance().getEnchantments(itemStack));
        if (enchantments.isEmpty()) {
            return null;
        }
        return new EnchantmentWrapper(itemStack, enchantments);
    }

    private EnchantmentWrapper(@Nonnull ItemStack itemStack, @Nonnull List<EnchantmentEntry> enchantments) {
        this.itemStack = itemStack;
        this.enchantments = enchantments;
        this.set = 0;
        this.lastSet = this.enchantments.size() / 12;
        this.nextCycle = (int)System.currentTimeMillis() / 1000 + 2;
    }

    public List<EnchantmentEntry> getEnchantments() {
        this.doCycle();
        int last = this.set * 11 + 11;
        if (last >= this.enchantments.size()) {
            last = this.enchantments.size();
        }
        return this.enchantments.subList(this.set * 11, last);
    }

    private void doCycle() {
        if ((int)System.currentTimeMillis() / 1000 > this.nextCycle) {
            if (!GuiScreen.func_146272_n()) {
                this.set = this.set == this.lastSet ? 0 : this.set + 1;
            }
            this.nextCycle = (int)System.currentTimeMillis() / 1000 + 2;
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.itemStack);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int y = 7;
        for (EnchantmentEntry enchantment : this.getEnchantments()) {
            Font.normal.print(enchantment.getTranslatedWithLevels(), 35, y);
            y += 10;
        }
        if (this.lastSet > 0) {
            String toPrint = TranslationHelper.getLocalPageInfo(this.set, this.lastSet);
            Font.normal.print(toPrint, 55, 120);
        }
    }
}

