/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.client.gui.calculators.GuiAtomicCalculator;
import sonar.calculator.mod.client.gui.calculators.GuiCalculator;
import sonar.calculator.mod.client.gui.calculators.GuiCraftingCalculator;
import sonar.calculator.mod.client.gui.calculators.GuiDynamicCalculator;
import sonar.calculator.mod.client.gui.calculators.GuiDynamicModule;
import sonar.calculator.mod.client.gui.calculators.GuiFlawlessCalculator;
import sonar.calculator.mod.client.gui.calculators.GuiScientificCalculator;
import sonar.calculator.mod.client.gui.generators.GuiConductorMast;
import sonar.calculator.mod.client.gui.machines.GuiAnalysingChamber;
import sonar.calculator.mod.client.gui.machines.GuiDualOutputSmelting;
import sonar.calculator.mod.client.gui.machines.GuiHealthProcessor;
import sonar.calculator.mod.client.gui.machines.GuiSmeltingBlock;
import sonar.calculator.mod.client.gui.misc.GuiFabricationChamber;
import sonar.calculator.mod.common.containers.ContainerAtomicCalculator;
import sonar.calculator.mod.common.containers.ContainerCalculator;
import sonar.calculator.mod.common.containers.ContainerConductorMast;
import sonar.calculator.mod.common.containers.ContainerCraftingCalculator;
import sonar.calculator.mod.common.containers.ContainerDualOutputSmelting;
import sonar.calculator.mod.common.containers.ContainerDynamicCalculator;
import sonar.calculator.mod.common.containers.ContainerFlawlessCalculator;
import sonar.calculator.mod.common.containers.ContainerScientificCalculator;
import sonar.calculator.mod.common.containers.ContainerSmeltingBlock;
import sonar.calculator.mod.common.recipes.AlgorithmSeparatorRecipes;
import sonar.calculator.mod.common.recipes.AnalysingChamberRecipes;
import sonar.calculator.mod.common.recipes.AtomicCalculatorRecipes;
import sonar.calculator.mod.common.recipes.CalculatorRecipes;
import sonar.calculator.mod.common.recipes.ConductorMastRecipes;
import sonar.calculator.mod.common.recipes.ExtractionChamberRecipes;
import sonar.calculator.mod.common.recipes.FabricationChamberRecipes;
import sonar.calculator.mod.common.recipes.FlawlessCalculatorRecipes;
import sonar.calculator.mod.common.recipes.HealthProcessorRecipes;
import sonar.calculator.mod.common.recipes.PrecisionChamberRecipes;
import sonar.calculator.mod.common.recipes.ProcessingChamberRecipes;
import sonar.calculator.mod.common.recipes.ReassemblyChamberRecipes;
import sonar.calculator.mod.common.recipes.RestorationChamberRecipes;
import sonar.calculator.mod.common.recipes.ScientificRecipes;
import sonar.calculator.mod.common.recipes.StoneSeparatorRecipes;
import sonar.calculator.mod.common.recipes.TreeHarvestRecipes;
import sonar.calculator.mod.integration.jei.AnalysingCategory;
import sonar.calculator.mod.integration.jei.AtomicCategory;
import sonar.calculator.mod.integration.jei.CalculatorCategory;
import sonar.calculator.mod.integration.jei.ConductorMastCategory;
import sonar.calculator.mod.integration.jei.DualProcessCategory;
import sonar.calculator.mod.integration.jei.FabricationCategory;
import sonar.calculator.mod.integration.jei.FlawlessCategory;
import sonar.calculator.mod.integration.jei.Recipes;
import sonar.calculator.mod.integration.jei.SickleCategory;
import sonar.calculator.mod.integration.jei.SingleProcessCategory;
import sonar.calculator.mod.integration.jei.ValueCategory;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.core.integration.jei.IJEIHandler;
import sonar.core.integration.jei.ISonarJEIRecipeBuilder;
import sonar.core.integration.jei.JEICategoryV2;
import sonar.core.integration.jei.JEIHelper;
import sonar.core.integration.jei.JEIRecipeV2;
import sonar.core.recipes.IRecipeHelperV2;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.RecipeHelperV2;

@JEIPlugin
public class CalculatorJEI
extends BlankModPlugin
implements ISonarJEIRecipeBuilder {
    public CalculatorJEI() {
        JEIHelper.registerRecipeBuilder((ISonarJEIRecipeBuilder)this);
    }

    public void register(IModRegistry registry) {
        Calculator.logger.info("Starting JEI Integration");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        for (Handlers handler : Handlers.values()) {
            registry.addRecipes((Collection)handler.getJEIRecipes());
            JEICategoryV2 cat = handler.getCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{cat});
            registry.addRecipeHandlers(new IRecipeHandler[]{cat});
            if (handler.getCrafterItemStack() != null) {
                registry.addRecipeCatalyst((Object)handler.getCrafterItemStack(), new String[]{handler.getUUID()});
            }
            Calculator.logger.info("Registering Recipe Handler: " + handler.getUUID());
        }
        jeiHelpers.getIngredientBlacklist().addIngredientToBlacklist((Object)Calculator.calculatorScreen);
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        registry.addRecipeCatalyst((Object)new ItemStack(Calculator.dynamicCalculator, 1), new String[]{Handlers.CALCULATOR.getUUID(), Handlers.SCIENTIFIC.getUUID(), Handlers.ATOMIC.getUUID()});
        registry.addRecipeCatalyst((Object)new ItemStack(Calculator.itemFlawlessCalculator, 1), new String[]{Handlers.FLAWLESS.getUUID(), Handlers.CALCULATOR.getUUID(), Handlers.SCIENTIFIC.getUUID(), Handlers.ATOMIC.getUUID()});
        registry.addRecipeCatalyst((Object)new ItemStack(Calculator.reinforcedFurnace, 1), new String[]{"minecraft.smelting"});
        registry.addRecipeCatalyst((Object)new ItemStack(Calculator.itemCraftingCalculator, 1), new String[]{"minecraft.crafting"});
        registry.addRecipeClickArea(GuiSmeltingBlock.ProcessingChamber.class, 77, 19, 24, 14, new String[]{Handlers.PROCESSING.getUUID()});
        registry.addRecipeClickArea(GuiSmeltingBlock.RestorationChamber.class, 77, 19, 24, 14, new String[]{Handlers.RESTORATION.getUUID()});
        registry.addRecipeClickArea(GuiSmeltingBlock.ReassemblyChamber.class, 77, 19, 24, 14, new String[]{Handlers.REASSEMBLY.getUUID()});
        registry.addRecipeClickArea(GuiSmeltingBlock.ReinforcedFurnace.class, 77, 19, 24, 14, new String[]{"minecraft.smelting"});
        registry.addRecipeClickArea(GuiDualOutputSmelting.ExtractionChamber.class, 63, 26, 24, 12, new String[]{Handlers.EXTRACTION.getUUID()});
        registry.addRecipeClickArea(GuiDualOutputSmelting.PrecisionChamber.class, 63, 26, 24, 12, new String[]{Handlers.PRECISION.getUUID()});
        registry.addRecipeClickArea(GuiDualOutputSmelting.StoneSeperator.class, 63, 26, 24, 12, new String[]{Handlers.STONE.getUUID()});
        registry.addRecipeClickArea(GuiDualOutputSmelting.AlgorithmSeperator.class, 63, 26, 24, 12, new String[]{Handlers.ALGORITHM.getUUID()});
        registry.addRecipeClickArea(GuiHealthProcessor.class, 80, 40, 16, 5, new String[]{Handlers.HEALTH.getUUID()});
        registry.addRecipeClickArea(GuiCalculator.class, 108, 40, 14, 6, new String[]{Handlers.CALCULATOR.getUUID()});
        registry.addRecipeClickArea(GuiScientificCalculator.class, 108, 40, 14, 6, new String[]{Handlers.SCIENTIFIC.getUUID()});
        registry.addRecipeClickArea(GuiAtomicCalculator.class, 109, 40, 10, 6, new String[]{Handlers.ATOMIC.getUUID()});
        registry.addRecipeClickArea(GuiFlawlessCalculator.class, 132, 40, 10, 6, new String[]{Handlers.FLAWLESS.getUUID()});
        registry.addRecipeClickArea(GuiCraftingCalculator.class, 88, 32, 28, 23, new String[]{"minecraft.crafting"});
        registry.addRecipeClickArea(GuiDynamicCalculator.class, 108, 14, 13, 6, new String[]{Handlers.CALCULATOR.getUUID()});
        registry.addRecipeClickArea(GuiDynamicCalculator.class, 108, 40, 13, 6, new String[]{Handlers.SCIENTIFIC.getUUID()});
        registry.addRecipeClickArea(GuiDynamicCalculator.class, 108, 66, 13, 6, new String[]{Handlers.ATOMIC.getUUID()});
        registry.addRecipeClickArea(GuiDynamicModule.class, 108, 14, 13, 6, new String[]{Handlers.CALCULATOR.getUUID()});
        registry.addRecipeClickArea(GuiDynamicModule.class, 108, 40, 13, 6, new String[]{Handlers.SCIENTIFIC.getUUID()});
        registry.addRecipeClickArea(GuiDynamicModule.class, 108, 66, 13, 6, new String[]{Handlers.ATOMIC.getUUID()});
        registry.addRecipeClickArea(GuiConductorMast.class, 79, 26, 18, 8, new String[]{Handlers.CONDUCTOR.getUUID()});
        registry.addRecipeClickArea(GuiFabricationChamber.class, 95, 89, 20, 15, new String[]{Handlers.FABRICATION.getUUID()});
        registry.addRecipeClickArea(GuiAnalysingChamber.class, 20, 24, 115, 13, new String[]{Handlers.ANALYSING.getUUID()});
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSmeltingBlock.class, Handlers.PROCESSING.getUUID(), 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSmeltingBlock.class, Handlers.RESTORATION.getUUID(), 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSmeltingBlock.class, Handlers.REASSEMBLY.getUUID(), 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerSmeltingBlock.class, "minecraft.smelting", 0, 1, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDualOutputSmelting.class, Handlers.EXTRACTION.getUUID(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDualOutputSmelting.class, Handlers.PRECISION.getUUID(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDualOutputSmelting.class, Handlers.STONE.getUUID(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDualOutputSmelting.class, Handlers.ALGORITHM.getUUID(), 0, 1, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerCalculator.class, Handlers.CALCULATOR.getUUID(), 0, 2, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerScientificCalculator.class, Handlers.SCIENTIFIC.getUUID(), 0, 2, 3, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerAtomicCalculator.class, Handlers.ATOMIC.getUUID(), 0, 3, 4, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerFlawlessCalculator.class, Handlers.FLAWLESS.getUUID(), 0, 4, 5, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerCraftingCalculator.class, "minecraft.crafting", 0, 9, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDynamicCalculator.class, Handlers.CALCULATOR.getUUID(), 1, 2, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDynamicCalculator.class, Handlers.SCIENTIFIC.getUUID(), 4, 2, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerDynamicCalculator.class, Handlers.ATOMIC.getUUID(), 7, 3, 10, 36);
        recipeTransferRegistry.addRecipeTransferHandler(ContainerConductorMast.class, Handlers.CONDUCTOR.getUUID(), 0, 1, 2, 36);
        Calculator.logger.info("Finished JEI Integration");
    }

    public Object buildRecipe(ISonarRecipe recipe, RecipeHelperV2<ISonarRecipe> helper) {
        if (Loader.isModLoaded((String)"jei") || Loader.isModLoaded((String)"JEI")) {
            for (Handlers handler : Handlers.values()) {
                if (!handler.helper.getRecipeID().equals(helper.getRecipeID())) continue;
                try {
                    return handler.recipeClass.getConstructor(RecipeHelperV2.class, ISonarRecipe.class).newInstance(handler.helper, recipe);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static enum Handlers implements IJEIHandler
    {
        PROCESSING((IRecipeHelperV2)ProcessingChamberRecipes.instance(), Calculator.processingChamber, "restorationchamber", Recipes.Processing.class),
        RESTORATION((IRecipeHelperV2)RestorationChamberRecipes.instance(), Calculator.restorationChamber, "restorationchamber", Recipes.Restoration.class),
        REASSEMBLY((IRecipeHelperV2)ReassemblyChamberRecipes.instance(), Calculator.reassemblyChamber, "restorationchamber", Recipes.Reassembly.class),
        EXTRACTION((IRecipeHelperV2)ExtractionChamberRecipes.instance(), Calculator.extractionChamber, "extractionchamber", Recipes.Extraction.class),
        PRECISION((IRecipeHelperV2)PrecisionChamberRecipes.instance(), Calculator.precisionChamber, "extractionchamber", Recipes.Precision.class),
        STONE((IRecipeHelperV2)StoneSeparatorRecipes.instance(), Calculator.stoneSeparator, "stoneseperator", Recipes.Stone.class),
        ALGORITHM((IRecipeHelperV2)AlgorithmSeparatorRecipes.instance(), Calculator.algorithmSeparator, "stoneseperator", Recipes.Algorithm.class),
        CALCULATOR((IRecipeHelperV2)CalculatorRecipes.instance(), Calculator.itemCalculator, "calculator", Recipes.Calculator.class),
        SCIENTIFIC((IRecipeHelperV2)ScientificRecipes.instance(), Calculator.itemScientificCalculator, "scientificcalculator", Recipes.Scientific.class),
        ATOMIC((IRecipeHelperV2)AtomicCalculatorRecipes.instance(), Calculator.atomicCalculator, "atomiccalculator", Recipes.Atomic.class),
        FLAWLESS((IRecipeHelperV2)FlawlessCalculatorRecipes.instance(), Calculator.itemFlawlessCalculator, "flawlesscalculator", Recipes.Flawless.class),
        HEALTH((IRecipeHelperV2)HealthProcessorRecipes.instance(), Calculator.healthProcessor, "guicalculatorplug", Recipes.Health.class),
        CONDUCTOR((IRecipeHelperV2)ConductorMastRecipes.instance(), Calculator.conductorMast, "conductorMast", Recipes.Conductor.class),
        FABRICATION((IRecipeHelperV2)FabricationChamberRecipes.instance(), Calculator.fabricationChamber, "fabrication_chamber_jei", Recipes.Fabrication.class),
        HARVEST((IRecipeHelperV2)TreeHarvestRecipes.instance(), Calculator.sickle, "sickle_harvesting", Recipes.Harvest.class),
        ANALYSING((IRecipeHelperV2)AnalysingChamberRecipes.instance(), Calculator.analysingChamber, "guicalculatorplug", Recipes.Analysing.class);

        public IRecipeHelperV2 helper;
        public String unlocalizedName;
        public String textureName;
        public Class<? extends JEIRecipeV2> recipeClass;
        public ItemStack crafter;

        private Handlers(IRecipeHelperV2 helper, Object stack, String textureName, Class<? extends JEIRecipeV2> recipeClass) {
            this.helper = helper;
            this.crafter = ItemStackHelper.getOrCreateStack((Object)stack);
            this.unlocalizedName = this.crafter.func_77977_a() + ".name";
            this.textureName = textureName;
            this.recipeClass = recipeClass;
        }

        public JEICategoryV2 getCategory(IGuiHelper guiHelper) {
            switch (this) {
                case SCIENTIFIC: 
                case CALCULATOR: {
                    return new CalculatorCategory(guiHelper, this);
                }
                case PROCESSING: 
                case RESTORATION: 
                case REASSEMBLY: {
                    return new SingleProcessCategory(guiHelper, this);
                }
                case EXTRACTION: 
                case PRECISION: 
                case STONE: 
                case ALGORITHM: {
                    return new DualProcessCategory(guiHelper, this);
                }
                case ATOMIC: {
                    return new AtomicCategory(guiHelper, this);
                }
                case FLAWLESS: {
                    return new FlawlessCategory(guiHelper, this);
                }
                case HEALTH: {
                    return new ValueCategory(guiHelper, this);
                }
                case CONDUCTOR: {
                    return new ConductorMastCategory(guiHelper, this);
                }
                case FABRICATION: {
                    return new FabricationCategory(guiHelper, this);
                }
                case HARVEST: {
                    return new SickleCategory(guiHelper, this);
                }
                case ANALYSING: {
                    return new AnalysingCategory(guiHelper, this);
                }
            }
            return null;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public String getTitle() {
            return this.unlocalizedName;
        }

        public Class<? extends JEIRecipeV2> getRecipeClass() {
            return this.recipeClass;
        }

        public IRecipeHelperV2 getRecipeHelper() {
            return this.helper;
        }

        public ArrayList<JEIRecipeV2> getJEIRecipes() {
            ArrayList<JEIRecipeV2> recipesV2 = new ArrayList<JEIRecipeV2>();
            if (this.helper instanceof RecipeHelperV2) {
                RecipeHelperV2 helper = (RecipeHelperV2)this.helper;
                for (ISonarRecipe recipe : helper.getRecipes()) {
                    try {
                        recipesV2.add(this.recipeClass.getConstructor(RecipeHelperV2.class, ISonarRecipe.class).newInstance(helper, recipe));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return recipesV2;
        }

        public ItemStack getCrafterItemStack() {
            return this.crafter;
        }

        public String getUUID() {
            return this.helper.getRecipeID();
        }
    }
}

