/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.machines.IGreenhouse;
import sonar.core.SonarCore;
import sonar.core.api.machines.IPausable;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.planting.IFertiliser;
import sonar.core.integration.planting.IHarvester;
import sonar.core.integration.planting.IPlanter;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.FailedCoords;

public abstract class TileEntityGreenhouse
extends TileEntityEnergyInventory
implements IGreenhouse,
IPausable,
IByteBufTile {
    public SyncEnum<State> houseState = new SyncEnum((Enum[])State.values(), 0);
    public SyncTagType.INT carbon = (SyncTagType.INT)new SyncTagType.INT(1).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP});
    public SyncTagType.BOOLEAN wasBuilt = new SyncTagType.BOOLEAN(2);
    public SyncTagType.BOOLEAN paused = new SyncTagType.BOOLEAN(3);
    public int maxLevel;
    public int plantTicks;
    public int planting;
    public int houseSize;
    public int checkTicks;
    public int plantsHarvested;
    public int plantsGrown;
    public int plantTick;
    public int type;
    public final int growthRF = CalculatorConfig.GROWTH_ENERGY_USAGE;
    public final int plantRF = CalculatorConfig.PLANTING_ENERGY_USAGE;
    public final int buildRF = CalculatorConfig.BUILD_ENERGY_USAGE;
    public final int farmlandRF = CalculatorConfig.FARMLAND_GENERATION_USAGE;
    public final int waterRF = CalculatorConfig.WATER_GENERATION_USAGE;
    public EnumFacing forward = EnumFacing.NORTH;
    public EnumFacing horizontal = EnumFacing.EAST;

    public TileEntityGreenhouse() {
        this.syncList.addParts(new IDirtyPart[]{this.houseState, this.carbon, this.wasBuilt, this.paused});
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.forward = EnumFacing.func_82600_a((int)this.func_145832_p()).func_176734_d();
        this.horizontal = SonarHelper.getHorizontal((EnumFacing)this.forward);
    }

    public void checkTile() {
        if (this.checkTicks >= 0 && this.checkTicks != 50) {
            ++this.checkTicks;
        }
        if (this.checkTicks == 50) {
            this.checkTicks = 0;
            if (this.checkStructure(GreenhouseAction.CHECK).getBoolean()) {
                if (!((Boolean)this.wasBuilt.getObject()).booleanValue()) {
                    this.setGas(0);
                    this.wasBuilt.setObject((Object)true);
                }
                this.houseState.setObject((Enum)State.COMPLETED);
                this.addFarmland();
            } else {
                this.houseState.setObject((Enum)State.INCOMPLETE);
            }
        }
    }

    public abstract FailedCoords checkStructure(GreenhouseAction var1);

    public abstract ArrayList<BlockPos> getPlantArea();

    public abstract void addFarmland();

    public static boolean isSeed(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IPlantable;
    }

    protected void growCrops(int repeat) {
        if (this.isClient()) {
            return;
        }
        ArrayList plantArea = (ArrayList)this.getPlantArea().clone();
        for (int i = 0; i < repeat; ++i) {
            if (this.storage.getEnergyStored() <= this.growthRF) continue;
            int rand = SonarCore.randInt((int)0, (int)(plantArea.size() - 1));
            BlockPos pos = (BlockPos)plantArea.get(rand);
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            for (IFertiliser fertiliser : SonarCore.fertilisers.getObjects()) {
                if (!fertiliser.canFertilise(this.field_145850_b, pos, state) || !fertiliser.canGrow(this.field_145850_b, pos, state, false)) continue;
                fertiliser.grow(this.field_145850_b, SonarCore.rand, pos, state);
                if (this.type != 3) continue;
                ++this.plantsGrown;
            }
            this.storage.modifyEnergyStored(-this.growthRF);
        }
    }

    protected void harvestCrops() {
        if (this.isClient() || this.storage.getEnergyStored() < this.plantRF) {
            return;
        }
        for (BlockPos pos : (ArrayList)this.getPlantArea().clone()) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            for (IHarvester harvester : SonarCore.harvesters.getObjects()) {
                if (!harvester.canHarvest(this.field_145850_b, pos, state) || !harvester.isReady(this.field_145850_b, pos, state)) continue;
                List stacks = harvester.getDrops(this.field_145850_b, pos, state, this.type);
                if (stacks != null) {
                    this.addHarvestedStacks(stacks, pos);
                    harvester.harvest(this.field_145850_b, pos, state, false);
                }
                this.storage.modifyEnergyStored(-this.growthRF);
            }
        }
    }

    @Nullable
    protected IItemHandler getAdjacentChestHandler() {
        return ItemTransferHelper.getItemHandlerOffset((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)this.forward.func_176734_d());
    }

    protected void addHarvestedStacks(List<ItemStack> array, BlockPos pos) {
        boolean keptBlock = false;
        ArrayList handlers = Lists.newArrayList((Object[])new IItemHandler[]{this.inv().getItemHandler(this.forward), this.getAdjacentChestHandler()});
        for (ItemStack stack : array) {
            if (stack.func_190926_b()) continue;
            if (!keptBlock && stack.func_77973_b() instanceof IPlantable) {
                keptBlock = true;
                ++this.plantsHarvested;
                continue;
            }
            if ((stack = ItemTransferHelper.doInsert((ItemStack)stack, (Iterable)handlers)).func_190926_b()) continue;
            BlockPos offset = this.func_174877_v().func_177972_a(this.forward.func_176734_d()).func_177972_a(EnumFacing.UP);
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), (ItemStack)stack);
        }
    }

    protected void plantCrops() {
        if (this.storage.getEnergyStored() < this.plantRF) {
            return;
        }
        for (BlockPos pos : (ArrayList)this.getPlantArea().clone()) {
            IPlanter planter;
            ItemStack seeds;
            IBlockState oldState = this.field_145850_b.func_180495_p(pos);
            Block block = oldState.func_177230_c();
            if (!block.isAir(oldState, (IBlockAccess)this.func_145831_w(), pos) && !block.func_176200_f((IBlockAccess)this.func_145831_w(), pos) || (seeds = this.getAvailableSeedStack()).func_190926_b() || (planter = this.getPlanter(seeds)) == null) continue;
            IBlockState state = planter.getPlant(seeds, this.func_145831_w(), pos);
            this.plantCrop(pos, state, seeds);
        }
    }

    private ItemStack getAvailableSeedStack() {
        for (ItemStack stack : this.getCropStacks()) {
            if (stack.func_190926_b() || stack.func_190916_E() <= 0) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private IPlanter getPlanter(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IPlanter planter : SonarCore.planters.getObjects()) {
            if (!planter.canTierPlant(stack, this.type)) continue;
            return planter;
        }
        return null;
    }

    public void plantCrop(BlockPos pos, IBlockState state, ItemStack stack) {
        if (state == null) {
            return;
        }
        this.storage.modifyEnergyStored(-this.plantRF);
        int size = stack.func_190916_E() - 1;
        stack.func_190920_e(size);
        this.func_145831_w().func_180501_a(pos, state, 3);
    }

    private int getSlotOffset() {
        switch (this.type) {
            case 2: {
                return 8;
            }
            case 1: {
                return 5;
            }
        }
        return 1;
    }

    public List<ItemStack> getCropStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        List seedSlots = this.slots();
        int offset = this.getSlotOffset();
        for (int j = 0; j < 9; ++j) {
            ItemStack stack = (ItemStack)seedSlots.get(j + offset);
            if (stack.func_190926_b() || !TileEntityGreenhouse.isSeed(stack)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public void setGas(int set) {
        if (set <= this.maxLevel) {
            this.carbon.setObject((Object)set);
        }
    }

    @Override
    public int getTier() {
        return this.type;
    }

    @Override
    public int getOxygen() {
        return this.maxLevel - (Integer)this.carbon.getObject();
    }

    @Override
    public int getCarbon() {
        return (Integer)this.carbon.getObject();
    }

    @Override
    public int maxGasLevel() {
        return this.maxLevel;
    }

    public void addGas(int add) {
        int carbonLevels = (Integer)this.carbon.getObject();
        if (carbonLevels + add < this.maxLevel && carbonLevels + add >= 0) {
            this.carbon.setObject((Object)(carbonLevels + add));
        } else {
            if (carbonLevels + add > this.maxLevel) {
                this.setGas(this.maxLevel);
            }
            if (carbonLevels + add < 0) {
                this.setGas(0);
            }
        }
    }

    public int type(String string) {
        int meta = this.func_145832_p();
        if (string.equals("r")) {
            if (meta == 3) {
                return 1;
            }
            if (meta == 4) {
                return 3;
            }
            if (meta == 5) {
                return 2;
            }
            if (meta == 2) {
                return 0;
            }
        }
        if (string.equals("l")) {
            if (meta == 3) {
                return 0;
            }
            if (meta == 4) {
                return 2;
            }
            if (meta == 5) {
                return 3;
            }
            if (meta == 2) {
                return 1;
            }
        }
        if (string.equals("d")) {
            if (meta == 3) {
                return 4;
            }
            if (meta == 4) {
                return 6;
            }
            if (meta == 5) {
                return 7;
            }
            if (meta == 2) {
                return 5;
            }
        }
        if (string.equals("d2")) {
            if (meta == 3) {
                return 5;
            }
            if (meta == 4) {
                return 7;
            }
            if (meta == 5) {
                return 6;
            }
            if (meta == 2) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public State getState() {
        return (State)this.houseState.getObject();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        switch ((State)this.houseState.getObject()) {
            case BUILDING: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.building"));
                break;
            }
            case INCOMPLETE: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.incomplete"));
                break;
            }
            case COMPLETED: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": " + FontHelper.translate((String)"greenhouse.complete"));
                break;
            }
            case DEMOLISHING: {
                currenttip.add(FontHelper.translate((String)"locator.state") + ": Demolishing");
                break;
            }
        }
        DecimalFormat dec = new DecimalFormat("##.##");
        int oxygen = this.getOxygen();
        int carbon = this.getCarbon();
        if (carbon != 0) {
            String carbonString = FontHelper.translate((String)"greenhouse.carbon") + ": " + dec.format(carbon * 100 / 100000) + '%';
            currenttip.add(carbonString);
        }
        if (oxygen != 0) {
            String oxygenString = FontHelper.translate((String)"greenhouse.oxygen") + ": " + dec.format(oxygen * 100 / 100000) + '%';
            currenttip.add(oxygenString);
        }
        currenttip.add(String.valueOf(this.storage.getEnergyStored()));
        return currenttip;
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 3) {
            this.onPause();
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 3) {
            this.onPause();
        }
    }

    public void onPause() {
        this.paused.invert();
    }

    public boolean isActive() {
        return (Boolean)this.paused.getObject() == false;
    }

    public boolean isPaused() {
        return (Boolean)this.paused.getObject();
    }

    public static enum GreenhouseAction {
        CAN_BUILD,
        CHECK,
        BUILD,
        DEMOLISH;

    }

    public static enum State {
        INCOMPLETE,
        BUILDING,
        COMPLETED,
        DEMOLISHING;

    }
}

