/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators;

import cofh.redstoneflux.api.IEnergyContainerItem;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.common.item.calculators.SonarModule;
import sonar.core.api.energy.ISonarEnergyItem;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.SonarEnergyItemWrapper;
import sonar.core.helpers.FontHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux")})
public class SonarUsageModule
extends SonarModule
implements ISonarEnergyItem,
IEnergyContainerItem {
    public int storage;

    public SonarUsageModule(IModule module, int storage) {
        super(module);
        this.storage = storage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        list.add(FontHelper.translate((String)"energy.stored") + ": " + this.getEnergyLevel(stack) + " RF");
        super.func_77624_a(stack, world, list, par4);
    }

    public long addEnergy(ItemStack stack, long maxReceive, ActionType action) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        long energy = stack.func_77978_p().func_74763_f("Energy");
        long energyReceived = Math.min(this.getFullCapacity(stack) - energy, Math.min((long)(this.storage / 10), maxReceive));
        if (!action.shouldSimulate()) {
            stack.func_77978_p().func_74772_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long removeEnergy(ItemStack stack, long maxExtract, ActionType action) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        long energy = stack.func_77978_p().func_74763_f("Energy");
        long energyExtracted = Math.min(energy, Math.min((long)(this.storage / 10), maxExtract));
        if (!action.shouldSimulate()) {
            stack.func_77978_p().func_74772_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyLevel(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        return stack.func_77978_p().func_74763_f("Energy");
    }

    public long getFullCapacity(ItemStack stack) {
        return this.storage;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        return (int)this.addEnergy(stack, maxReceive, ActionType.getTypeForAction((boolean)simulate));
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return (int)this.removeEnergy(stack, maxExtract, ActionType.getTypeForAction((boolean)simulate));
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack stack) {
        return (int)this.getEnergyLevel(stack);
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack stack) {
        return (int)this.getFullCapacity(stack);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b() || newStack.func_77952_i() != oldStack.func_77952_i();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new SonarEnergyItemWrapper((ISonarEnergyItem)this, stack);
    }
}

