/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.machines;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import sonar.calculator.mod.common.tileentity.TileEntityBuildingGreenhouse;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityAdvancedGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityBasicGreenhouse;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.common.block.SonarBlockContainer;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.FailedCoords;
import sonar.core.utils.ISpecialTooltip;

public abstract class Greenhouse
extends SonarBlockContainer
implements ISpecialTooltip {
    public Greenhouse() {
        super(SonarMaterials.machine, true);
    }

    public abstract TileEntity func_149915_a(@Nonnull World var1, int var2);

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityBuildingGreenhouse)) return true;
        TileEntityBuildingGreenhouse house = (TileEntityBuildingGreenhouse)tile;
        if (!player.func_70093_af()) {
            if (player == null) return true;
            if (world.field_72995_K) return true;
            FlexibleGuiHandler.instance().openBasicTile(player, world, pos, 0);
            return true;
        }
        if (house.houseState.getObject() == TileEntityGreenhouse.State.INCOMPLETE) {
            if (!((Boolean)house.wasBuilt.getObject()).booleanValue()) {
                if (house.storage.getEnergyStored() < house.requiredBuildEnergy) {
                    FontHelper.sendMessage((String)FontHelper.translate((String)"energy.notEnough"), (World)world, (EntityPlayer)player);
                    return true;
                }
                if (!house.hasRequiredStacks()) {
                    FontHelper.sendMessage((String)house.getRequiredStacks().toString(), (World)world, (EntityPlayer)player);
                    return true;
                }
                if (house.houseState.getObject() == TileEntityGreenhouse.State.INCOMPLETE && !((Boolean)house.wasBuilt.getObject()).booleanValue()) {
                    FailedCoords coords = house.createBlock();
                    if (!coords.getBoolean()) {
                        FontHelper.sendMessage((String)(FontHelper.translate((String)"greenhouse.block") + ' ' + "X: " + coords.getCoords().getX() + " Y: " + coords.getCoords().getY() + " Z: " + coords.getCoords().getZ() + " - " + FontHelper.translate((String)"greenhouse.blocking")), (World)world, (EntityPlayer)player);
                        return true;
                    }
                    FontHelper.sendMessage((String)FontHelper.translate((String)"greenhouse.construction"), (World)world, (EntityPlayer)player);
                    return true;
                }
            } else {
                FailedCoords coords = house.checkStructure(TileEntityGreenhouse.GreenhouseAction.CHECK);
                if (!coords.getBoolean()) {
                    FontHelper.sendMessage((String)("X: " + coords.getCoords().getX() + " Y: " + coords.getCoords().getY() + " Z: " + coords.getCoords().getZ() + " - " + FontHelper.translate((String)"greenhouse.equal") + ' ' + coords.getBlock()), (World)world, (EntityPlayer)player);
                    return true;
                }
            }
        }
        if (house.houseState.getObject() != TileEntityGreenhouse.State.COMPLETED) return true;
        FontHelper.sendMessage((ITextComponent)new TextComponentTranslation("greenhouse.complete", new Object[0]), (World)world, (EntityPlayer)player);
        return true;
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list, NBTTagCompound tag) {
        CalculatorHelper.addEnergytoToolTip(stack, world, list);
        CalculatorHelper.addGasToolTip(stack, world, list);
    }

    public static class Basic
    extends Greenhouse {
        @Override
        public TileEntity func_149915_a(World var1, int var2) {
            return new TileEntityBasicGreenhouse();
        }
    }

    public static class Advanced
    extends Greenhouse {
        @Override
        public TileEntity func_149915_a(World var1, int var2) {
            return new TileEntityAdvancedGreenhouse();
        }
    }
}

