/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.machines;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.calculator.mod.common.tileentity.machines.TileEntityDockingStation;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.common.block.SonarBlockContainer;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.upgrades.MachineUpgrade;
import sonar.core.utils.ISpecialTooltip;

public class DockingStation
extends SonarBlockContainer
implements ISpecialTooltip {
    public DockingStation() {
        super(SonarMaterials.machine, true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.95f, 1.0);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null) {
            TileEntity target;
            if (player.func_184614_ca().func_77973_b() instanceof MachineUpgrade) {
                return false;
            }
            if (!this.insertCalculator(player, world, pos) && !world.field_72995_K && (target = world.func_175625_s(pos)) instanceof TileEntityDockingStation) {
                TileEntityDockingStation station = (TileEntityDockingStation)target;
                if (TileEntityDockingStation.getInputStackSize(station.calcStack) != 0) {
                    FlexibleGuiHandler.instance().openBasicTile(player, world, pos, 0);
                } else {
                    FontHelper.sendMessage((String)FontHelper.translate((String)"docking.noCalculator"), (World)world, (EntityPlayer)player);
                }
            }
        }
        return true;
    }

    public boolean insertCalculator(EntityPlayer player, World world, BlockPos pos) {
        TileEntity target;
        player.func_184614_ca();
        if (TileEntityDockingStation.getInputStackSize(player.func_184614_ca()) > 0 && (target = world.func_175625_s(pos)) instanceof TileEntityDockingStation) {
            TileEntityDockingStation station = (TileEntityDockingStation)target;
            if (station.calcStack.func_190926_b()) {
                station.calcStack = player.func_184614_ca().func_77946_l();
                player.func_184614_ca().func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        ItemStack stack;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDockingStation && (stack = ((TileEntityDockingStation)tile).calcStack) != null && !stack.func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(@Nonnull World var1, int var2) {
        return new TileEntityDockingStation();
    }

    public void addSpecialToolTip(ItemStack stack, World player, List<String> list, NBTTagCompound tag) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }
}

