/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonExtended;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;

public class GuiButtonArrow
extends GuiButtonExtended {
    private final Direction direction;
    private final Image[] directionImages;

    public GuiButtonArrow(int id, int x, int y, Direction direction) {
        super(id, x, y, direction.width, direction.height, "", true);
        this.direction = direction;
        this.directionImages = GuiButtonArrow.getDirectionImage(direction);
    }

    protected static Image[] getDirectionImage(Direction direction) {
        if (direction == Direction.NORTH) {
            return Images.BUTTON_ARROW_UP;
        }
        if (direction == Direction.EAST) {
            return Images.BUTTON_ARROW_RIGHT;
        }
        if (direction == Direction.SOUTH) {
            return Images.BUTTON_ARROW_DOWN;
        }
        if (direction == Direction.WEST) {
            return Images.BUTTON_ARROW_LEFT;
        }
        return null;
    }

    @Override
    protected void drawBackground(Minecraft minecraft, int hoverState) {
        this.directionImages[hoverState].draw((Gui)this, this.field_146128_h, this.field_146129_i);
    }

    @Override
    protected void drawButtonInner(Minecraft minecraft, int i, int j, boolean mouseOver) {
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static enum Direction {
        NORTH(15, 10),
        EAST(10, 15),
        SOUTH(15, 10),
        WEST(10, 15);

        private final int width;
        private final int height;

        private Direction(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

