/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.spiritfurnace;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.item.WeightedItemStack;
import org.cyclops.evilcraft.block.SpiritFurnaceConfig;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileSpiritFurnace;

public class BoxCookTickAction
implements ITickAction<TileSpiritFurnace> {
    public static final Map<Class<? extends EntityLivingBase>, List<WeightedItemStack>> MOBDROP_OVERRIDES = Maps.newHashMap();
    public static final Map<Class<? extends EntityLivingBase>, ResourceLocation> MOBDROPTABLES_OVERRIDES = Maps.newHashMap();
    public static final Map<UUID, List<WeightedItemStack>> PLAYERDROP_OVERRIDES = Maps.newHashMap();
    public static final ItemStack[] PLAYERDROP_RANDOM;

    public static void overrideMobDrop(Class<? extends EntityLivingBase> entity, Set<WeightedItemStack> drops) {
        MOBDROP_OVERRIDES.put(entity, WeightedItemStack.createWeightedList(drops));
    }

    public static void overrideMobDrop(Class<? extends EntityLivingBase> entity, ResourceLocation drops) {
        MOBDROPTABLES_OVERRIDES.put(entity, drops);
    }

    public static void overridePlayerDrop(String playerId, ItemStack drop) {
        PLAYERDROP_OVERRIDES.put(UUID.fromString(playerId), WeightedItemStack.createWeightedList((Set)Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(drop, 1)})));
    }

    @Override
    public boolean canTick(TileSpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.isForceHalt() && !tile.isCaughtError() && tile.canWork() && tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, 0) && !this.getCookStack(tile).func_190926_b() && tile.canConsume(this.getCookStack(tile))) {
            for (int slotId : tile.getProduceSlots()) {
                ItemStack production = tile.getInventory().func_70301_a(slotId);
                if (production != null && production.func_190916_E() >= production.func_77976_d()) continue;
                return tile.isSizeValidForEntity();
            }
        }
        return false;
    }

    protected ItemStack getCookStack(TileSpiritFurnace tile) {
        return tile.getInventory().func_70301_a(tile.getConsumeSlot());
    }

    protected ItemStack getPlayerSkull(String playerName) {
        ItemStack itemStack = new ItemStack(Items.field_151144_bL, 1, 3);
        itemStack.func_77982_d(new NBTTagCompound());
        itemStack.func_77978_p().func_74778_a("SkullOwner", playerName);
        return itemStack;
    }

    protected ItemStack getPlayerDeterminedDrop(String playerId) {
        return PLAYERDROP_RANDOM[Math.abs(playerId.hashCode() % PLAYERDROP_RANDOM.length)].func_77946_l();
    }

    protected void doNextDrop(TileSpiritFurnace tile) {
        EntityLiving entity = tile.getEntity();
        if (entity != null) {
            World world = tile.func_145831_w();
            SoundEvent deathSound = ObfuscationHelpers.getDeathSound((EntityLivingBase)entity);
            if (SpiritFurnaceConfig.mobDeathSounds && deathSound != null) {
                BlockPos pos = tile.func_174877_v();
                world.func_184133_a(null, pos, deathSound, entity.func_184176_by(), 0.5f + world.field_73012_v.nextFloat() * 0.2f, 1.0f);
            }
            if (tile.isPlayer()) {
                WeightedItemStack weightedItemStack;
                ItemStack drop;
                UUID playerUuid = UUID.fromString(tile.getPlayerId());
                LinkedList possibleDrops = Lists.newLinkedList();
                possibleDrops.add(new WeightedItemStack(this.getPlayerDeterminedDrop(tile.getPlayerId()), 1));
                List<WeightedItemStack> overridenDrops = PLAYERDROP_OVERRIDES.get(playerUuid);
                if (overridenDrops != null) {
                    possibleDrops.addAll(overridenDrops);
                }
                if (!"Forgotten Player".equals(tile.getPlayerName())) {
                    possibleDrops.add(new WeightedItemStack(this.getPlayerSkull(tile.getPlayerName()), 1));
                }
                if (!(drop = (weightedItemStack = WeightedItemStack.getRandomWeightedItemStack((List)possibleDrops, (Random)world.field_73012_v)).getItemStackWithRandomizedSize(world.field_73012_v)).func_190926_b()) {
                    tile.onItemDrop(drop);
                }
            } else if (MOBDROP_OVERRIDES.containsKey(entity.getClass())) {
                List<WeightedItemStack> possibleDrops = MOBDROP_OVERRIDES.get(entity.getClass());
                WeightedItemStack weightedItemStack = WeightedItemStack.getRandomWeightedItemStack(possibleDrops, (Random)world.field_73012_v);
                ItemStack drop = weightedItemStack.getItemStackWithRandomizedSize(world.field_73012_v);
                if (!drop.func_190926_b()) {
                    tile.onItemDrop(drop);
                }
            } else {
                ResourceLocation deathLootTable = MOBDROPTABLES_OVERRIDES.containsKey(entity.getClass()) ? MOBDROPTABLES_OVERRIDES.get(entity.getClass()) : ObfuscationHelpers.getLootTable(entity);
                if (deathLootTable != null) {
                    LootTable loottable = world.func_184146_ak().func_186521_a(deathLootTable);
                    if (loottable == null) {
                        throw new RuntimeException("Could not find the loot table " + deathLootTable + ", an invalid loot table might have been configured as spirit furnace mob drop override.");
                    }
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)tile.func_145831_w()).func_186472_a((Entity)entity).func_186470_a((EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)tile.func_145831_w()))).func_186473_a(DamageSource.field_76377_j);
                    for (ItemStack itemstack : loottable.func_186462_a(world.field_73012_v, lootcontext$builder.func_186471_a())) {
                        tile.onItemDrop(itemstack);
                    }
                }
            }
        }
    }

    protected int getRequiredMb(TileSpiritFurnace tile, int tick) {
        int baseUsage = tile.isPlayer() ? SpiritFurnaceConfig.playerMBPerTick : (tile.getEntity() != null && !tile.getEntity().func_184222_aU() ? SpiritFurnaceConfig.bossMBPerTick : SpiritFurnaceConfig.mBPerTick);
        MutableDouble drain = new MutableDouble((double)baseUsage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritFurnace.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public void onTick(TileSpiritFurnace tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), true);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            this.doNextDrop(tile);
        }
    }

    @Override
    public float getRequiredTicks(TileSpiritFurnace tile, int slot, int tick) {
        int requiredTicksBase;
        EntityLiving entity = tile.getEntity();
        if (entity == null) {
            requiredTicksBase = SpiritFurnaceConfig.requiredTicksPerHp;
        } else {
            try {
                requiredTicksBase = (int)((entity.func_110143_aJ() + (float)entity.func_70658_aO()) * (float)SpiritFurnaceConfig.requiredTicksPerHp);
            }
            catch (Exception e) {
                requiredTicksBase = 40 * SpiritFurnaceConfig.requiredTicksPerHp;
            }
        }
        MutableDouble duration = new MutableDouble((double)requiredTicksBase);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(duration, TileSpiritFurnace.UPGRADEEVENT_SPEED));
        return (int)duration.getValue().doubleValue();
    }

    static {
        if (SpiritFurnaceConfig.villagerDropEmeraldChance > 0) {
            BoxCookTickAction.overrideMobDrop(EntityVillager.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack(Items.field_151166_bC), 1), new WeightedItemStack(ItemStack.field_190927_a, SpiritFurnaceConfig.villagerDropEmeraldChance - 1)}));
        }
        BoxCookTickAction.overrideMobDrop(EntityWither.class, Sets.newHashSet((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack(Items.field_151156_bN), 1)}));
        BoxCookTickAction.overridePlayerDrop("068d4de0-3a75-4c6a-9f01-8c37e16a394c", new ItemStack(Items.field_151166_bC));
        BoxCookTickAction.overridePlayerDrop("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c", new ItemStack(Items.field_151041_m));
        BoxCookTickAction.overridePlayerDrop("777e7aa3-9373-4511-8d75-f99d23ebe252", new ItemStack(Items.field_151100_aR, 1, 3).func_151001_c("Lekkere Stront"));
        BoxCookTickAction.overridePlayerDrop("3e13f558-fb72-4949-a842-07879924bc49", new ItemStack(Items.field_151128_bU));
        BoxCookTickAction.overridePlayerDrop("b5c31e33-8224-4f96-a4bf-73721be9d2ec", new ItemStack(Blocks.field_150347_e));
        BoxCookTickAction.overridePlayerDrop("b2faeaab-fc87-4f91-98d3-836024f268ae", new ItemStack(Blocks.field_150460_al).func_151001_c("Fuurnas"));
        BoxCookTickAction.overridePlayerDrop("069a79f4-44e9-4726-a5be-fca90e38aaf5", new ItemStack(Items.field_151153_ao, 1, 1));
        BoxCookTickAction.overridePlayerDrop("853c80ef-3c37-49fd-aa49-938b674adae6", new ItemStack(Items.field_151063_bx, 1, 91).func_151001_c("jeb_"));
        BoxCookTickAction.overridePlayerDrop("61699b2e-d327-4a01-9f1e-0ea8c3f06bc6", new ItemStack(Items.field_151063_bx, 1, 91).func_151001_c("Dinnerbone"));
        BoxCookTickAction.overridePlayerDrop("bbb87dbe-690f-4205-bdc5-72ffb8ebc29d", new ItemStack(Blocks.field_150347_e, 45).func_151001_c("direwolf20"));
        BoxCookTickAction.overridePlayerDrop("0b7509f0-2458-4160-9ce1-2772b9a45ac2", new ItemStack(Items.field_151147_al));
        PLAYERDROP_RANDOM = new ItemStack[]{new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151065_br), new ItemStack(Items.field_151128_bU), new ItemStack((Item)Items.field_151023_V), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151160_bD), new ItemStack(Items.field_151143_au), new ItemStack((Item)Items.field_151097_aZ), new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151158_bO), new ItemStack(Items.field_151064_bs), new ItemStack(Items.field_151141_av), new ItemStack(Items.field_151060_bw), new ItemStack(Items.field_151019_K), new ItemStack(Items.field_151146_bM), new ItemStack(Items.field_151137_ax), new ItemStack(Blocks.field_150402_ci), new ItemStack(Blocks.field_150368_y), new ItemStack(Blocks.field_150425_aM), new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150438_bZ)};
    }
}

