/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.client.model.DelegatingChildDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.block.DarkTank;

public class ModelDarkTank
extends DelegatingChildDynamicItemAndBlockModel {
    private final int capacity;
    private final FluidStack fluidStack;

    public ModelDarkTank(IBakedModel baseModel) {
        super(baseModel);
        this.capacity = 0;
        this.fluidStack = null;
    }

    public ModelDarkTank(IBakedModel baseModel, int capacity, FluidStack fluidStack, IBlockState blockState, EnumFacing facing, long rand) {
        super(baseModel, blockState, facing, rand);
        this.capacity = capacity;
        this.fluidStack = fluidStack;
    }

    public ModelDarkTank(IBakedModel baseModel, int capacity, FluidStack fluidStack, ItemStack itemStack, World world, EntityLivingBase entity) {
        super(baseModel, itemStack, world, entity);
        this.capacity = capacity;
        this.fluidStack = fluidStack;
    }

    public List<BakedQuad> getGeneralQuads() {
        ArrayList combinedList = Lists.newArrayList();
        if (this.fluidStack != null) {
            combinedList.addAll(this.getFluidQuads(this.fluidStack, this.capacity));
        }
        combinedList.addAll(this.baseModel.func_188616_a(this.blockState, this.getRenderingSide(), this.rand));
        return combinedList;
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        int capacity = (Integer)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)state), DarkTank.TANK_CAPACITY, (Object)0);
        FluidStack fluidStack = (FluidStack)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)((IExtendedBlockState)state), DarkTank.TANK_FLUID, null);
        return new ModelDarkTank(this.baseModel, capacity, fluidStack, state, side, rand);
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, EntityLivingBase entity) {
        IFluidHandlerItemCapacity fluidHandler = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)itemStack);
        if (!itemStack.func_190926_b() && fluidHandler != null) {
            int capacity = fluidHandler.getCapacity();
            FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
            return new ModelDarkTank(this.baseModel, capacity, fluidStack, itemStack, world, entity);
        }
        return new ModelDarkTank(this.baseModel, 0, null, itemStack, world, entity);
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity) {
        float height = Math.min(0.99f, (float)fluidStack.amount / (float)capacity) / 1.01f;
        ArrayList quads = Lists.newArrayList();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TextureAtlasSprite texture = RenderHelpers.getFluidIcon((FluidStack)fluidStack, (EnumFacing)side);
            int color = RenderHelpers.getFluidBakedQuadColor((FluidStack)fluidStack);
            if (side == EnumFacing.UP) {
                ModelDarkTank.addBakedQuadRotated((List)quads, (float)0.13f, (float)0.87f, (float)0.13f, (float)0.87f, (float)height, (TextureAtlasSprite)texture, (EnumFacing)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
                continue;
            }
            if (side == EnumFacing.DOWN) {
                ModelDarkTank.addBakedQuadRotated((List)quads, (float)0.13f, (float)0.87f, (float)0.13f, (float)0.87f, (float)0.95f, (TextureAtlasSprite)texture, (EnumFacing)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])ROTATION_UV);
                continue;
            }
            float x1 = 0.13f;
            float x2 = 0.87f;
            float z1 = 0.01f;
            float z2 = height;
            if (side == EnumFacing.EAST || side == EnumFacing.SOUTH) {
                z1 = 0.99f - height;
                z2 = 0.99f;
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                float tmp1 = x1;
                float tmp2 = x2;
                x1 = z1;
                x2 = z2;
                z1 = tmp1;
                z2 = tmp2;
            }
            float[][] uvs = side == EnumFacing.UP || side == EnumFacing.DOWN ? new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}} : new float[][]{{1.0f, 0.0f}, {1.0f, height}, {0.0f, height}, {0.0f, 0.0f}};
            ModelDarkTank.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)0.87f, (TextureAtlasSprite)texture, (EnumFacing)side, (int)ROTATION_FIX[side.ordinal()], (boolean)true, (int)color, (float[][])uvs);
        }
        return quads;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }
}

