/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.client.gui.container.GuiSpiritFurnace;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableBlockContainerGuiTankInfo;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;
import org.cyclops.evilcraft.tileentity.TileSpiritFurnace;

public class SpiritFurnace
extends ConfigurableBlockContainerGuiTankInfo
implements CubeDetector.IDetectionListener {
    @BlockProperty
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private static SpiritFurnace _instance = null;

    public static SpiritFurnace getInstance() {
        return _instance;
    }

    public SpiritFurnace(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e, TileSpiritFurnace.class);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
        this.setRotatable(true);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        return !TileSpiritFurnace.canWork(world, blockPos) || super.func_180639_a(world, blockPos, blockState, entityplayer, hand, side, par7, par8, par9);
    }

    public Item func_180660_a(IBlockState blockState, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    private void triggerDetector(World world, BlockPos blockPos, boolean valid) {
        TileSpiritFurnace.detector.detect(world, blockPos, valid ? null : blockPos, true);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            this.triggerDetector(world, pos, true);
        }
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState blockState) {
        super.func_176213_c(world, blockPos, blockState);
        if (!world.field_72995_K) {
            this.triggerDetector(world, blockPos, true);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            this.triggerDetector(world, pos, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public void onDetect(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            boolean change = (Boolean)world.func_180495_p(location).func_177229_b((IProperty)ACTIVE) == false;
            world.func_180501_a(location, world.func_180495_p(location).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            TileEntity tile = world.func_175625_s(location);
            if (tile != null) {
                ((TileSpiritFurnace)tile).setSize(valid ? size : Vec3i.field_177959_e);
            }
            if (change) {
                TileSpiritFurnace.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    public Class<? extends Container> getContainer() {
        return ContainerSpiritFurnace.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiSpiritFurnace.class;
    }

    @Override
    public int getDefaultCapacity() {
        return 10000;
    }
}

