/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.core.block.IBlockRarityProvider;
import org.cyclops.evilcraft.entity.monster.VengeanceSpiritData;
import org.cyclops.evilcraft.tileentity.TileBoxOfEternalClosure;

public class BoxOfEternalClosure
extends ConfigurableBlockContainer
implements IInformationProvider,
IBlockRarityProvider {
    public static final String FORGOTTEN_PLAYER = "Forgotten Player";
    private static final int LIGHT_LEVEL = 6;
    @BlockProperty(ignore=true)
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static BoxOfEternalClosure _instance = null;
    public static ItemStack boxOfEternalClosureFilled;

    public static BoxOfEternalClosure getInstance() {
        return _instance;
    }

    public BoxOfEternalClosure(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileBoxOfEternalClosure.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setRotatable(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos blockPos) {
        EnumFacing rotation = (EnumFacing)BlockHelpers.getSafeBlockStateProperty((IBlockState)source.func_180495_p(blockPos), (IProperty)FACING, (Comparable)EnumFacing.NORTH);
        if (rotation == EnumFacing.EAST || rotation == EnumFacing.WEST) {
            return new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, (double)0.43f, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, (double)0.43f, 0.75);
    }

    public EnumBlockRenderType func_149645_b(IBlockState blockState) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    public ResourceLocation getSpiritNameOrNull(ItemStack itemStack) {
        return this.hasPlayer(itemStack) ? new ResourceLocation("zombie") : this.getSpiritNameOrNullFromNBTTag(itemStack.func_77978_p());
    }

    private ResourceLocation getSpiritNameOrNullFromNBTTag(NBTTagCompound tag) {
        return TileBoxOfEternalClosure.getSpiritNameOrNullFromNBTTag(tag);
    }

    public static void setVengeanceSwarmContent(ItemStack itemStack) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound spiritTag = new NBTTagCompound();
        VengeanceSpiritData spiritData = new VengeanceSpiritData();
        spiritData.setSwarm(true);
        spiritData.setRandomSwarmTier(RANDOM);
        spiritData.writeNBT(spiritTag);
        tag.func_74782_a("spiritTag", (NBTBase)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public static void setPlayerContent(ItemStack itemStack, UUID playerId) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound spiritTag = new NBTTagCompound();
        VengeanceSpiritData spiritData = new VengeanceSpiritData();
        spiritData.setPlayerId(playerId.toString());
        spiritData.setPlayerName(FORGOTTEN_PLAYER);
        tag.func_74778_a("playerId", spiritData.getPlayerId());
        tag.func_74778_a("playerName", spiritData.getPlayerName());
        spiritData.writeNBT(spiritTag);
        tag.func_74782_a("spiritTag", (NBTBase)spiritTag);
        itemStack.func_77982_d(tag);
    }

    public String getPlayerName(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerName", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return itemStack.func_77978_p().func_74779_i("playerName");
        }
        return "";
    }

    public String getPlayerId(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("playerId", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
            return itemStack.func_77978_p().func_74779_i("playerId");
        }
        return "";
    }

    public boolean hasPlayer(ItemStack itemStack) {
        return !this.getPlayerId(itemStack).isEmpty();
    }

    public String getInfo(ItemStack itemStack) {
        String content = TextFormatting.ITALIC + L10NHelpers.localize((String)"general.evilcraft.info.empty", (Object[])new Object[0]);
        if (this.hasPlayer(itemStack)) {
            content = this.getPlayerName(itemStack);
        } else {
            ResourceLocation id = this.getSpiritNameOrNull(itemStack);
            if (id != null) {
                String name = EntityList.func_191302_a((ResourceLocation)id);
                if (name == null) {
                    name = id.func_110623_a();
                }
                content = L10NHelpers.getLocalizedEntityName((String)name);
            }
        }
        return TextFormatting.BOLD + L10NHelpers.localize((String)(this.func_149739_a() + ".info.content"), (Object[])new Object[]{TextFormatting.RESET + content});
    }

    @SideOnly(value=Side.CLIENT)
    public void provideInformation(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
    }

    public boolean func_176196_c(World world, BlockPos blockPos) {
        return BlockHelpers.doesBlockHaveSolidTopSurface((IBlockAccess)world, (BlockPos)blockPos);
    }

    public void func_189540_a(IBlockState blockState, World world, BlockPos blockPos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, blockPos)) {
            this.func_176226_b(world, blockPos, blockState, 0);
            world.func_175698_g(blockPos);
        }
        super.func_189540_a(blockState, world, blockPos, block, fromPos);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).isClosed()) {
            tile.open();
            return true;
        }
        return super.func_180639_a(world, blockPos, state, entityplayer, hand, side, hitX, hitY, hitZ);
    }

    private float randomFloat(Random random, float min, float delta) {
        return min + random.nextFloat() * delta;
    }

    public int getLightValue(IBlockState blockState, IBlockAccess world, BlockPos blockPos) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).getLidAngle() > 0.0f) {
            return 6;
        }
        return super.getLightValue(blockState, world, blockPos);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!BlockHelpers.isValidCreativeTab((Block)this, (CreativeTabs)tab)) {
            return;
        }
        list.add((Object)new ItemStack((Block)this));
        list.add((Object)boxOfEternalClosureFilled);
    }

    @Override
    public EnumRarity getRarity(ItemStack itemStack) {
        return this.hasPlayer(itemStack) ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }

    public boolean func_149740_M(IBlockState blockState) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos blockPos) {
        TileBoxOfEternalClosure tile;
        if (world.func_175625_s(blockPos) != null && (tile = (TileBoxOfEternalClosure)world.func_175625_s(blockPos)).hasSpirit()) {
            return 15;
        }
        return super.func_180641_l(blockState, world, blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState blockState, World world, RayTraceResult target, ParticleManager particleManager) {
        if (target != null) {
            RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (World)world, (IBlockState)Blocks.field_150343_Z.func_176223_P(), (BlockPos)target.func_178782_a(), (EnumFacing)target.field_178784_b);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager) {
        RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (World)world, (IBlockState)Blocks.field_150343_Z.func_176223_P(), (BlockPos)pos, (EnumFacing)EnumFacing.UP);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addLandingEffects(IBlockState blockState, WorldServer world, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        RenderHelpers.addBlockHitEffects((ParticleManager)Minecraft.func_71410_x().field_71452_i, (World)world, (IBlockState)Blocks.field_150343_Z.func_176223_P(), (BlockPos)blockPosition, (EnumFacing)EnumFacing.UP);
        return true;
    }
}

