/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.common.blocks;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.tammodized.common.blocks.TamBlockContainer;

public abstract class TamBlockFarmland
extends TamBlockContainer {
    public static final PropertyInteger MOISTURE = PropertyInteger.func_177719_a((String)"moisture", (int)0, (int)7);
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public TamBlockFarmland(CreativeTabs tab, Material material, String n, float hardness, SoundType sound) {
        super(tab, material, n, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149713_g(255);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FARMLAND_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected abstract IBlockState getParentBlockState();

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)MOISTURE);
        if (!(this.hasWater(worldIn, pos) || this.getWaterBlock() == Blocks.field_150355_j && worldIn.func_175727_C(pos.func_177984_a()))) {
            if (i > 0) {
                this.updateState(worldIn, pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops(worldIn, pos)) {
                this.updateState(worldIn, pos, this.getParentBlockState());
            }
        } else if (i < 7) {
            this.updateState(worldIn, pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private void updateState(World world, BlockPos pos, IBlockState newState, int flag) {
        TileEntity te1 = world.func_175625_s(pos);
        world.func_180501_a(pos, newState, flag);
        TileEntity te2 = world.func_175625_s(pos);
        this.updateTiles(te1, te2);
    }

    private void updateState(World world, BlockPos pos, IBlockState newState) {
        TileEntity te1 = world.func_175625_s(pos);
        world.func_175656_a(pos, newState);
        TileEntity te2 = world.func_175625_s(pos);
        this.updateTiles(te1, te2);
    }

    protected abstract void updateTiles(TileEntity var1, TileEntity var2);

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextFloat() < fallDistance - 0.5f && entityIn instanceof EntityLivingBase && (entityIn instanceof EntityPlayer || worldIn.func_82736_K().func_82766_b("mobGriefing")) && entityIn.field_70130_N * entityIn.field_70130_N * entityIn.field_70131_O > 0.512f) {
            this.updateState(worldIn, pos, this.getParentBlockState());
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    private boolean hasCrops(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)block);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.getPlantList().contains(plantable);
    }

    protected abstract ArrayList<IPlantable> getPlantList();

    public boolean isFertile(World world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)MOISTURE) > 0;
    }

    private boolean hasWater(World worldIn, BlockPos pos) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c() != this.getWaterBlock()) continue;
            return true;
        }
        return false;
    }

    protected abstract Block getWaterBlock();

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        super.func_189540_a(state, worldIn, pos, blockIn, p_189540_5_);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.updateState(worldIn, pos, this.getParentBlockState());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getParentBlockState().func_177230_c().func_180660_a(this.getParentBlockState(), rand, fortune);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getParentBlockState().func_177230_c());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(meta & 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MOISTURE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE});
    }
}

