/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.logic.ITorchRegistry;

abstract class TorchRegistry
implements ITorchRegistry {
    private final List<BlockPos> torches = new ArrayList<BlockPos>();
    private int checkIndex;

    TorchRegistry() {
    }

    protected abstract boolean shouldHandleEntityType(Class<? extends Entity> var1);

    protected abstract int getTorchRange();

    protected abstract boolean isBlockStateValid(IBlockState var1);

    @Override
    public final void register(BlockPos pos) {
        if (!this.torches.contains(pos)) {
            this.torches.add(pos);
        }
    }

    @Override
    public final void unregister(BlockPos pos) {
        this.torches.remove(pos);
    }

    @Override
    public final boolean shouldEntityBeBlocked(Entity entity) {
        return this.shouldHandleEntityType(entity.getClass()) && this.isEntityInRange(entity);
    }

    private boolean isEntityInRange(Entity entity) {
        int torchRange = this.getTorchRange();
        int torchRangeSq = torchRange * torchRange;
        BlockPos pos = entity.func_180425_c();
        for (BlockPos torch : this.torches) {
            double dx = (double)torch.func_177958_n() + 0.5 - (double)pos.func_177958_n();
            double dy = Math.abs((double)torch.func_177956_o() + 0.5 - (double)pos.func_177956_o());
            double dz = (double)torch.func_177952_p() + 0.5 - (double)pos.func_177952_p();
            if (!(dx * dx + dz * dz <= (double)torchRangeSq) || !(dy <= (double)torchRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onGlobalTick(World world) {
        if (this.torches.size() == 0) {
            return;
        }
        this.checkIndex = (this.checkIndex + 1) % this.torches.size();
        BlockPos loc = this.torches.get(this.checkIndex);
        if (world == null) {
            return;
        }
        if (world.func_175667_e(loc) && !this.isBlockStateValid(world.func_180495_p(loc))) {
            TorchMasterMod.Log.info("Torch @ " + loc + " is no longer valid, removing from registry");
            this.unregister(loc);
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList tagList = new NBTTagList();
        for (BlockPos loc : this.torches) {
            tagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)loc));
        }
        return tagList;
    }

    public void deserializeNBT(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            BlockPos loc = NBTUtil.func_186861_c((NBTTagCompound)entry);
            this.register(loc);
        }
    }
}

