/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.structure;

import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.util.struct.StructureBlockArray;
import hellfirepvp.astralsorcery.common.world.WorldGenAttributeCommon;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public abstract class WorldGenAttributeStructure
extends WorldGenAttributeCommon {
    private static boolean generatingStructure = false;
    protected final StructureGenBuffer.StructureType type;
    protected float idealDistance = 256.0f;
    private final WorldGenAttributeCommon.StructureQuery query;

    public WorldGenAttributeStructure(int attributeVersion, String entry, WorldGenAttributeCommon.StructureQuery query, StructureGenBuffer.StructureType type, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... types) {
        super(attributeVersion, entry, ignoreBiomeSpecifications, types);
        this.query = query;
        this.type = type;
    }

    public WorldGenAttributeStructure(int attributeVersion, int defaultChance, String entry, WorldGenAttributeCommon.StructureQuery query, StructureGenBuffer.StructureType type, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... types) {
        super(attributeVersion, defaultChance, entry, ignoreBiomeSpecifications, types);
        this.query = query;
        this.type = type;
    }

    public StructureGenBuffer.StructureType getStructureType() {
        return this.type;
    }

    public float getIdealDistance() {
        return this.idealDistance;
    }

    public StructureBlockArray getStructureTemplate() {
        return this.query.getStructure();
    }

    protected StructureGenBuffer getBuffer(World world) {
        return (StructureGenBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.STRUCTURE_GEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (generatingStructure) {
            return;
        }
        generatingStructure = true;
        try {
            super.generate(random, chunkX, chunkZ, world);
        }
        finally {
            generatingStructure = false;
        }
    }

    @Override
    protected void loadAdditionalConfigEntries(Configuration cfg) {
        super.loadAdditionalConfigEntries(cfg);
        this.idealDistance = cfg.getFloat("idealDistance", this.cfgEntry.getConfigurationSection(), this.idealDistance, 1.0f, 16384.0f, "Sets the 'ideal' distance between 2 structures of the same type. If the distance is lower, it's unlikely that the same type of structure will spawn,if it's higher it's more likely that this type of structure will spawn. Only has influence if the config option 'respectIdealStructureDistances' is enabled.");
    }
}

