/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.starmap.ActiveStarMap;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.base.TileSkybound;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMapDrawingTable
extends TileSkybound {
    public static int RUN_TIME = 200;
    private ItemStack slotIn = ItemStack.field_190927_a;
    private ItemStack slotGlassLens = ItemStack.field_190927_a;
    private int runTick = 0;

    @Override
    protected void onFirstTick() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.playWorkEffects();
        } else if (ConstellationSkyHandler.getInstance().isNight(this.func_145831_w()) && this.doesSeeSky() && !this.slotGlassLens.func_190926_b() && this.slotGlassLens.func_77973_b() instanceof ItemInfusedGlass) {
            ActiveStarMap map = ItemInfusedGlass.getMapEngravingInformations(this.slotGlassLens);
            if (map != null && !this.slotIn.func_190926_b() && !this.hasParchment() && (this.slotIn.func_77956_u() && map.tryApplyEnchantments(ItemUtils.copyStackWithSize(this.slotIn, this.slotIn.func_190916_E())) || this.slotIn.func_77973_b() instanceof ItemPotion && PotionUtils.func_185189_a((ItemStack)this.slotIn).isEmpty())) {
                ++this.runTick;
                if (this.runTick > RUN_TIME) {
                    if (this.slotIn.func_77956_u()) {
                        if (this.slotIn.func_77973_b() instanceof ItemBook && map.tryApplyEnchantments(ItemUtils.copyStackWithSize(this.slotIn, this.slotIn.func_190916_E()))) {
                            this.slotIn = new ItemStack(Items.field_151134_bR);
                        }
                        map.tryApplyEnchantments(this.slotIn);
                        if (this.slotGlassLens.func_96631_a(1, rand, null)) {
                            this.slotGlassLens.func_190918_g(1);
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, rand.nextFloat() * 0.5f + 1.0f, rand.nextFloat() * 0.2f + 0.8f);
                        }
                    } else if (PotionUtils.func_185189_a((ItemStack)this.slotIn).isEmpty()) {
                        map.tryApplyPotionEffects(this.slotIn);
                        if (rand.nextInt(3) == 0 && this.slotGlassLens.func_96631_a(1, rand, null)) {
                            this.slotGlassLens.func_190918_g(1);
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, rand.nextFloat() * 0.5f + 1.0f, rand.nextFloat() * 0.2f + 0.8f);
                        }
                    }
                    this.runTick = 0;
                }
                this.markForUpdate();
            } else if (this.runTick > 0) {
                this.runTick = 0;
                this.markForUpdate();
            }
        } else if (this.runTick > 0) {
            this.runTick = 0;
            this.markForUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playWorkEffects() {
        Color c;
        if ((double)this.getPercRunning() <= 1.0E-4) {
            return;
        }
        Vector3 offset = new Vector3(-0.3125, 1.505, -0.1875);
        int random = rand.nextInt(12);
        if (random > 5) {
            offset.addX(1.5);
        }
        offset.addZ((double)(random % 6) * 0.25);
        offset.add((double)rand.nextFloat() * 0.1, 0.0, (double)rand.nextFloat() * 0.1).add((Vec3i)this.field_174879_c);
        switch (random) {
            case 0: {
                c = new Color(0xFF0800);
                break;
            }
            case 1: {
                c = new Color(0xFFCC00);
                break;
            }
            case 2: {
                c = new Color(0x6FFF00);
                break;
            }
            case 3: {
                c = new Color(64767);
                break;
            }
            case 4: {
                c = new Color(10495);
                break;
            }
            case 5: {
                c = new Color(0xFF00FE);
                break;
            }
            case 6: {
                c = new Color(15759360);
                break;
            }
            case 7: {
                c = new Color(11857920);
                break;
            }
            case 8: {
                c = new Color(126976);
                break;
            }
            case 9: {
                c = new Color(31472);
                break;
            }
            case 10: {
                c = new Color(3735792);
                break;
            }
            default: {
                c = new Color(15728763);
            }
        }
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(offset.getX(), offset.getY(), offset.getZ());
        p.scale(rand.nextFloat() * 0.1f + 0.15f).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
        p.gravity(0.006f).setMaxAge(rand.nextInt(30) + 35);
        p.setColor(c);
        if (rand.nextFloat() < this.getPercRunning()) {
            Vector3 center = new Vector3(this).add(0.5, 1.0, 0.5);
            AstralSorcery.proxy.fireLightning(this.field_145850_b, offset, center, c);
            p = EffectHelper.genericFlareParticle(offset.getX(), offset.getY(), offset.getZ());
            p.scale(rand.nextFloat() * 0.1f + 0.15f).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.gravity(0.004f).setMaxAge(rand.nextInt(30) + 35);
            p.setColor(c);
            Vector3 mov = center.clone().subtract(offset).normalize().multiply(0.05 * (double)rand.nextFloat());
            p.motion(mov.getX(), mov.getY(), mov.getZ());
        }
        if (this.getPercRunning() > 0.1f) {
            if (rand.nextInt(3) == 0) {
                EffectHandler.getInstance().lightbeam(offset.clone().addY(0.4 + (double)rand.nextFloat() * 0.3), offset, 0.2f).setColorOverlay(c);
            }
            if (rand.nextInt(4) == 0) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        c = new Color(21700);
                        break;
                    }
                    case 1: {
                        c = new Color(7809482);
                        break;
                    }
                    case 2: {
                        c = new Color(10495);
                    }
                }
                offset = new Vector3(this).add(rand.nextFloat(), 1.0, rand.nextFloat());
                EffectHandler.getInstance().lightbeam(offset.clone().addY(1.0 + (double)rand.nextFloat() * 0.4), offset, 0.5).setColorOverlay(c);
            }
        }
    }

    public int addParchment(int amt) {
        if (!this.slotIn.func_190926_b()) {
            if (this.slotIn.func_77973_b() instanceof ItemCraftingComponent && this.slotIn.func_77952_i() == ItemCraftingComponent.MetaType.PARCHMENT.getMeta()) {
                int current = this.slotIn.func_190916_E();
                if (current + amt <= 64) {
                    this.slotIn.func_190920_e(current += amt);
                    this.markForUpdate();
                    return 0;
                }
                int ret = current + amt - 64;
                this.slotIn.func_190920_e(64);
                this.markForUpdate();
                return ret;
            }
            return amt;
        }
        this.slotIn = ItemCraftingComponent.MetaType.PARCHMENT.asStack();
        this.slotIn.func_190920_e(amt);
        this.markForUpdate();
        return 0;
    }

    @Nonnull
    public ItemStack getSlotGlassLens() {
        return this.slotGlassLens;
    }

    @Nonnull
    public ItemStack getSlotIn() {
        return this.slotIn;
    }

    public float getPercRunning() {
        return (float)this.runTick / (float)RUN_TIME;
    }

    public void putSlotIn(ItemStack stack) {
        this.slotIn = ItemUtils.copyStackWithSize(stack, 1);
        this.markForUpdate();
    }

    public void putGlassLens(ItemStack glassLens) {
        this.slotGlassLens = ItemUtils.copyStackWithSize(glassLens, Math.min(glassLens.func_190916_E(), 1));
        this.markForUpdate();
    }

    public boolean hasParchment() {
        return !this.slotIn.func_190926_b() && this.slotIn.func_77973_b() instanceof ItemCraftingComponent && this.slotIn.func_77952_i() == ItemCraftingComponent.MetaType.PARCHMENT.getMeta() && this.slotIn.func_190916_E() > 0;
    }

    public boolean hasUnengravedGlass() {
        return !this.slotGlassLens.func_190926_b() && this.slotGlassLens.func_77973_b() instanceof ItemInfusedGlass && ItemInfusedGlass.getMapEngravingInformations(this.slotGlassLens) == null;
    }

    public void dropContents() {
        if (!this.slotIn.func_190926_b()) {
            ItemUtils.dropItemNaturally(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.slotIn);
            this.slotIn = ItemStack.field_190927_a;
        }
        if (!this.slotGlassLens.func_190926_b()) {
            ItemUtils.dropItemNaturally(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.slotGlassLens);
            this.slotGlassLens = ItemStack.field_190927_a;
        }
        this.markForUpdate();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.runTick = compound.func_74762_e("runTick");
        this.slotIn = new ItemStack(compound.func_74775_l("slotIn"));
        this.slotGlassLens = new ItemStack(compound.func_74775_l("slotGlassLens"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeNetNBT(compound);
        compound.func_74768_a("runTick", this.runTick);
        NBTTagCompound tag = new NBTTagCompound();
        this.slotIn.func_77955_b(tag);
        compound.func_74782_a("slotIn", (NBTBase)tag);
        tag = new NBTTagCompound();
        this.slotGlassLens.func_77955_b(tag);
        compound.func_74782_a("slotGlassLens", (NBTBase)tag);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.5, 0.5, 0.5);
    }

    public void tryEngraveGlass(List<DrawnConstellation> constellations) {
        if (this.hasParchment() && this.hasUnengravedGlass()) {
            this.getSlotIn().func_190918_g(1);
            ItemInfusedGlass.setMapEngravingInformations(this.getSlotGlassLens(), ActiveStarMap.compile(constellations));
            this.markForUpdate();
            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.ENGRAVE_LENS, new Vector3(this));
            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_145850_b, (Vec3i)this.func_174877_v(), 16.0));
        }
    }

    public boolean burnParchment() {
        if (this.hasParchment() && this.hasUnengravedGlass()) {
            this.getSlotIn().func_190918_g(1);
            this.markForUpdate();
            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.BURN_PARCHMENT, new Vector3(this));
            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_145850_b, (Vec3i)this.func_174877_v(), 16.0));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void burnParchmentEffects(PktParticleEvent pktParticleEvent) {
        Vector3 at;
        int i;
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        Vector3 offset = pktParticleEvent.getVec();
        Minecraft.func_71410_x().field_71441_e.func_184134_a(offset.getX(), offset.getY(), offset.getZ(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, rand.nextFloat() * 0.5f + 1.0f, rand.nextFloat() * 0.1f + 0.9f, true);
        offset.add(-0.2, 1.1, -0.2);
        for (i = 0; i < 50; ++i) {
            at = offset.clone().add((double)rand.nextFloat() * 1.4, 0.0, (double)rand.nextFloat() * 1.4);
            Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.FLAME, at.getX(), at.getY(), at.getZ(), (double)rand.nextFloat() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1), new int[0]);
        }
        for (i = 0; i < 70; ++i) {
            at = offset.clone().add((double)rand.nextFloat() * 1.4, 0.0, (double)rand.nextFloat() * 1.4);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            p.gravity(0.004).scale(rand.nextFloat() * 0.1f + 0.2f).setMaxAge(rand.nextInt(20) + 20);
            p.motion((double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.05 * (double)(rand.nextBoolean() ? 1 : -1), (double)rand.nextFloat() * 0.15 * (double)(rand.nextBoolean() ? 1 : -1));
            p.setColor(new Color(Color.HSBtoRGB(rand.nextFloat() * 360.0f, 1.0f, 1.0f)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void engraveLensEffects(PktParticleEvent pktParticleEvent) {
    }
}

